package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait SubnetState {
  def unwrap: software.amazon.awssdk.services.ec2.model.SubnetState
}
object SubnetState {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.SubnetState
  ): zio.aws.ec2.model.SubnetState = value match {
    case software.amazon.awssdk.services.ec2.model.SubnetState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.SubnetState.PENDING =>
      val r = pending
      r
    case software.amazon.awssdk.services.ec2.model.SubnetState.AVAILABLE =>
      val r = available
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.SubnetState {
    override def unwrap: software.amazon.awssdk.services.ec2.model.SubnetState =
      software.amazon.awssdk.services.ec2.model.SubnetState.UNKNOWN_TO_SDK_VERSION
  }
  case object pending extends zio.aws.ec2.model.SubnetState {
    override def unwrap: software.amazon.awssdk.services.ec2.model.SubnetState =
      software.amazon.awssdk.services.ec2.model.SubnetState.PENDING
  }
  case object available extends zio.aws.ec2.model.SubnetState {
    override def unwrap: software.amazon.awssdk.services.ec2.model.SubnetState =
      software.amazon.awssdk.services.ec2.model.SubnetState.AVAILABLE
  }
}
