package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SubnetAssociation(
    subnetId: Optional[String] = Optional.Absent,
    state: Optional[
      zio.aws.ec2.model.TransitGatewayMulitcastDomainAssociationState
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.SubnetAssociation = {
    import SubnetAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.SubnetAssociation
      .builder()
      .optionallyWith(subnetId.map(value => value: java.lang.String))(
        _.subnetId
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.SubnetAssociation.ReadOnly =
    zio.aws.ec2.model.SubnetAssociation.wrap(buildAwsValue())
}
object SubnetAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.SubnetAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.SubnetAssociation =
      zio.aws.ec2.model.SubnetAssociation(
        subnetId.map(value => value),
        state.map(value => value)
      )
    def subnetId: Optional[String]
    def state: Optional[
      zio.aws.ec2.model.TransitGatewayMulitcastDomainAssociationState
    ]
    def getSubnetId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subnetId", subnetId)
    def getState: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayMulitcastDomainAssociationState
    ] = AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.SubnetAssociation
  ) extends zio.aws.ec2.model.SubnetAssociation.ReadOnly {
    override val subnetId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetId())
      .map(value => value: String)
    override val state: Optional[
      zio.aws.ec2.model.TransitGatewayMulitcastDomainAssociationState
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.state())
      .map(value =>
        zio.aws.ec2.model.TransitGatewayMulitcastDomainAssociationState
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.SubnetAssociation
  ): zio.aws.ec2.model.SubnetAssociation.ReadOnly = new Wrapper(impl)
}
