package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{Integer, DateTime}
import scala.jdk.CollectionConverters._
final case class ReservedInstances(
    availabilityZone: Optional[String] = Optional.Absent,
    duration: Optional[Long] = Optional.Absent,
    end: Optional[DateTime] = Optional.Absent,
    fixedPrice: Optional[Float] = Optional.Absent,
    instanceCount: Optional[Integer] = Optional.Absent,
    instanceType: Optional[zio.aws.ec2.model.InstanceType] = Optional.Absent,
    productDescription: Optional[zio.aws.ec2.model.RIProductDescription] =
      Optional.Absent,
    reservedInstancesId: Optional[String] = Optional.Absent,
    start: Optional[DateTime] = Optional.Absent,
    state: Optional[zio.aws.ec2.model.ReservedInstanceState] = Optional.Absent,
    usagePrice: Optional[Float] = Optional.Absent,
    currencyCode: Optional[zio.aws.ec2.model.CurrencyCodeValues] =
      Optional.Absent,
    instanceTenancy: Optional[zio.aws.ec2.model.Tenancy] = Optional.Absent,
    offeringClass: Optional[zio.aws.ec2.model.OfferingClassType] =
      Optional.Absent,
    offeringType: Optional[zio.aws.ec2.model.OfferingTypeValues] =
      Optional.Absent,
    recurringCharges: Optional[Iterable[zio.aws.ec2.model.RecurringCharge]] =
      Optional.Absent,
    scope: Optional[zio.aws.ec2.model.Scope] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ReservedInstances = {
    import ReservedInstances.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ReservedInstances
      .builder()
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(duration.map(value => value: java.lang.Long))(_.duration)
      .optionallyWith(end.map(value => DateTime.unwrap(value): Instant))(_.end)
      .optionallyWith(fixedPrice.map(value => value: java.lang.Float))(
        _.fixedPrice
      )
      .optionallyWith(instanceCount.map(value => value: java.lang.Integer))(
        _.instanceCount
      )
      .optionallyWith(instanceType.map(value => value.unwrap))(_.instanceType)
      .optionallyWith(productDescription.map(value => value.unwrap))(
        _.productDescription
      )
      .optionallyWith(
        reservedInstancesId.map(value => value: java.lang.String)
      )(_.reservedInstancesId)
      .optionallyWith(start.map(value => DateTime.unwrap(value): Instant))(
        _.start
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(usagePrice.map(value => value: java.lang.Float))(
        _.usagePrice
      )
      .optionallyWith(currencyCode.map(value => value.unwrap))(_.currencyCode)
      .optionallyWith(instanceTenancy.map(value => value.unwrap))(
        _.instanceTenancy
      )
      .optionallyWith(offeringClass.map(value => value.unwrap))(_.offeringClass)
      .optionallyWith(offeringType.map(value => value.unwrap))(_.offeringType)
      .optionallyWith(
        recurringCharges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.recurringCharges)
      .optionallyWith(scope.map(value => value.unwrap))(_.scope)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ReservedInstances.ReadOnly =
    zio.aws.ec2.model.ReservedInstances.wrap(buildAwsValue())
}
object ReservedInstances {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ReservedInstances
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ReservedInstances =
      zio.aws.ec2.model.ReservedInstances(
        availabilityZone.map(value => value),
        duration.map(value => value),
        end.map(value => value),
        fixedPrice.map(value => value),
        instanceCount.map(value => value),
        instanceType.map(value => value),
        productDescription.map(value => value),
        reservedInstancesId.map(value => value),
        start.map(value => value),
        state.map(value => value),
        usagePrice.map(value => value),
        currencyCode.map(value => value),
        instanceTenancy.map(value => value),
        offeringClass.map(value => value),
        offeringType.map(value => value),
        recurringCharges.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        scope.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def availabilityZone: Optional[String]
    def duration: Optional[Long]
    def end: Optional[DateTime]
    def fixedPrice: Optional[Float]
    def instanceCount: Optional[Integer]
    def instanceType: Optional[zio.aws.ec2.model.InstanceType]
    def productDescription: Optional[zio.aws.ec2.model.RIProductDescription]
    def reservedInstancesId: Optional[String]
    def start: Optional[DateTime]
    def state: Optional[zio.aws.ec2.model.ReservedInstanceState]
    def usagePrice: Optional[Float]
    def currencyCode: Optional[zio.aws.ec2.model.CurrencyCodeValues]
    def instanceTenancy: Optional[zio.aws.ec2.model.Tenancy]
    def offeringClass: Optional[zio.aws.ec2.model.OfferingClassType]
    def offeringType: Optional[zio.aws.ec2.model.OfferingTypeValues]
    def recurringCharges
        : Optional[List[zio.aws.ec2.model.RecurringCharge.ReadOnly]]
    def scope: Optional[zio.aws.ec2.model.Scope]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getDuration: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("duration", duration)
    def getEnd: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("end", end)
    def getFixedPrice: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("fixedPrice", fixedPrice)
    def getInstanceCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("instanceCount", instanceCount)
    def getInstanceType: ZIO[Any, AwsError, zio.aws.ec2.model.InstanceType] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getProductDescription
        : ZIO[Any, AwsError, zio.aws.ec2.model.RIProductDescription] =
      AwsError.unwrapOptionField("productDescription", productDescription)
    def getReservedInstancesId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("reservedInstancesId", reservedInstancesId)
    def getStart: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("start", start)
    def getState: ZIO[Any, AwsError, zio.aws.ec2.model.ReservedInstanceState] =
      AwsError.unwrapOptionField("state", state)
    def getUsagePrice: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("usagePrice", usagePrice)
    def getCurrencyCode
        : ZIO[Any, AwsError, zio.aws.ec2.model.CurrencyCodeValues] =
      AwsError.unwrapOptionField("currencyCode", currencyCode)
    def getInstanceTenancy: ZIO[Any, AwsError, zio.aws.ec2.model.Tenancy] =
      AwsError.unwrapOptionField("instanceTenancy", instanceTenancy)
    def getOfferingClass
        : ZIO[Any, AwsError, zio.aws.ec2.model.OfferingClassType] =
      AwsError.unwrapOptionField("offeringClass", offeringClass)
    def getOfferingType
        : ZIO[Any, AwsError, zio.aws.ec2.model.OfferingTypeValues] =
      AwsError.unwrapOptionField("offeringType", offeringType)
    def getRecurringCharges
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.RecurringCharge.ReadOnly]] =
      AwsError.unwrapOptionField("recurringCharges", recurringCharges)
    def getScope: ZIO[Any, AwsError, zio.aws.ec2.model.Scope] =
      AwsError.unwrapOptionField("scope", scope)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ReservedInstances
  ) extends zio.aws.ec2.model.ReservedInstances.ReadOnly {
    override val availabilityZone: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZone())
      .map(value => value: String)
    override val duration: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.duration())
      .map(value => value: Long)
    override val end: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.end())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val fixedPrice: Optional[Float] = zio.aws.core.internal
      .optionalFromNullable(impl.fixedPrice())
      .map(value => value: Float)
    override val instanceCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceCount())
      .map(value => value: Integer)
    override val instanceType: Optional[zio.aws.ec2.model.InstanceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceType())
        .map(value => zio.aws.ec2.model.InstanceType.wrap(value))
    override val productDescription
        : Optional[zio.aws.ec2.model.RIProductDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.productDescription())
        .map(value => zio.aws.ec2.model.RIProductDescription.wrap(value))
    override val reservedInstancesId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.reservedInstancesId())
      .map(value => value: String)
    override val start: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.start())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val state: Optional[zio.aws.ec2.model.ReservedInstanceState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.ec2.model.ReservedInstanceState.wrap(value))
    override val usagePrice: Optional[Float] = zio.aws.core.internal
      .optionalFromNullable(impl.usagePrice())
      .map(value => value: Float)
    override val currencyCode: Optional[zio.aws.ec2.model.CurrencyCodeValues] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currencyCode())
        .map(value => zio.aws.ec2.model.CurrencyCodeValues.wrap(value))
    override val instanceTenancy: Optional[zio.aws.ec2.model.Tenancy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceTenancy())
        .map(value => zio.aws.ec2.model.Tenancy.wrap(value))
    override val offeringClass: Optional[zio.aws.ec2.model.OfferingClassType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.offeringClass())
        .map(value => zio.aws.ec2.model.OfferingClassType.wrap(value))
    override val offeringType: Optional[zio.aws.ec2.model.OfferingTypeValues] =
      zio.aws.core.internal
        .optionalFromNullable(impl.offeringType())
        .map(value => zio.aws.ec2.model.OfferingTypeValues.wrap(value))
    override val recurringCharges
        : Optional[List[zio.aws.ec2.model.RecurringCharge.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recurringCharges())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.RecurringCharge.wrap(item)
          }.toList
        )
    override val scope: Optional[zio.aws.ec2.model.Scope] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scope())
        .map(value => zio.aws.ec2.model.Scope.wrap(value))
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ReservedInstances
  ): zio.aws.ec2.model.ReservedInstances.ReadOnly = new Wrapper(impl)
}
