package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ReservedInstanceReservationValue(
    reservationValue: Optional[zio.aws.ec2.model.ReservationValue] =
      Optional.Absent,
    reservedInstanceId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ReservedInstanceReservationValue = {
    import ReservedInstanceReservationValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ReservedInstanceReservationValue
      .builder()
      .optionallyWith(reservationValue.map(value => value.buildAwsValue()))(
        _.reservationValue
      )
      .optionallyWith(reservedInstanceId.map(value => value: java.lang.String))(
        _.reservedInstanceId
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ReservedInstanceReservationValue.ReadOnly =
    zio.aws.ec2.model.ReservedInstanceReservationValue.wrap(buildAwsValue())
}
object ReservedInstanceReservationValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ReservedInstanceReservationValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ReservedInstanceReservationValue =
      zio.aws.ec2.model.ReservedInstanceReservationValue(
        reservationValue.map(value => value.asEditable),
        reservedInstanceId.map(value => value)
      )
    def reservationValue: Optional[zio.aws.ec2.model.ReservationValue.ReadOnly]
    def reservedInstanceId: Optional[String]
    def getReservationValue
        : ZIO[Any, AwsError, zio.aws.ec2.model.ReservationValue.ReadOnly] =
      AwsError.unwrapOptionField("reservationValue", reservationValue)
    def getReservedInstanceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("reservedInstanceId", reservedInstanceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ReservedInstanceReservationValue
  ) extends zio.aws.ec2.model.ReservedInstanceReservationValue.ReadOnly {
    override val reservationValue
        : Optional[zio.aws.ec2.model.ReservationValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reservationValue())
        .map(value => zio.aws.ec2.model.ReservationValue.wrap(value))
    override val reservedInstanceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.reservedInstanceId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ReservedInstanceReservationValue
  ): zio.aws.ec2.model.ReservedInstanceReservationValue.ReadOnly = new Wrapper(
    impl
  )
}
