package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class NetworkAcl(
    associations: Optional[Iterable[zio.aws.ec2.model.NetworkAclAssociation]] =
      Optional.Absent,
    entries: Optional[Iterable[zio.aws.ec2.model.NetworkAclEntry]] =
      Optional.Absent,
    isDefault: Optional[Boolean] = Optional.Absent,
    networkAclId: Optional[String] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent,
    vpcId: Optional[String] = Optional.Absent,
    ownerId: Optional[String] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.NetworkAcl = {
    import NetworkAcl.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.NetworkAcl
      .builder()
      .optionallyWith(
        associations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.associations)
      .optionallyWith(
        entries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.entries)
      .optionallyWith(isDefault.map(value => value: java.lang.Boolean))(
        _.isDefault
      )
      .optionallyWith(networkAclId.map(value => value: java.lang.String))(
        _.networkAclId
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.NetworkAcl.ReadOnly =
    zio.aws.ec2.model.NetworkAcl.wrap(buildAwsValue())
}
object NetworkAcl {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.NetworkAcl] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.NetworkAcl = zio.aws.ec2.model.NetworkAcl(
      associations.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      entries.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      isDefault.map(value => value),
      networkAclId.map(value => value),
      tags.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      vpcId.map(value => value),
      ownerId.map(value => value)
    )
    def associations
        : Optional[List[zio.aws.ec2.model.NetworkAclAssociation.ReadOnly]]
    def entries: Optional[List[zio.aws.ec2.model.NetworkAclEntry.ReadOnly]]
    def isDefault: Optional[Boolean]
    def networkAclId: Optional[String]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def vpcId: Optional[String]
    def ownerId: Optional[String]
    def getAssociations: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.NetworkAclAssociation.ReadOnly
    ]] = AwsError.unwrapOptionField("associations", associations)
    def getEntries
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.NetworkAclEntry.ReadOnly]] =
      AwsError.unwrapOptionField("entries", entries)
    def getIsDefault: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isDefault", isDefault)
    def getNetworkAclId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("networkAclId", networkAclId)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.NetworkAcl
  ) extends zio.aws.ec2.model.NetworkAcl.ReadOnly {
    override val associations
        : Optional[List[zio.aws.ec2.model.NetworkAclAssociation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.NetworkAclAssociation.wrap(item)
          }.toList
        )
    override val entries
        : Optional[List[zio.aws.ec2.model.NetworkAclEntry.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.entries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.NetworkAclEntry.wrap(item)
          }.toList
        )
    override val isDefault: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isDefault())
      .map(value => value: Boolean)
    override val networkAclId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.networkAclId())
      .map(value => value: String)
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
    override val vpcId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => value: String)
    override val ownerId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.NetworkAcl
  ): zio.aws.ec2.model.NetworkAcl.ReadOnly = new Wrapper(impl)
}
