package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VpnConnectionId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ModifyVpnTunnelCertificateRequest(
    vpnConnectionId: VpnConnectionId,
    vpnTunnelOutsideIpAddress: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyVpnTunnelCertificateRequest = {
    import ModifyVpnTunnelCertificateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyVpnTunnelCertificateRequest
      .builder()
      .vpnConnectionId(
        VpnConnectionId.unwrap(vpnConnectionId): java.lang.String
      )
      .vpnTunnelOutsideIpAddress(vpnTunnelOutsideIpAddress: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifyVpnTunnelCertificateRequest.ReadOnly =
    zio.aws.ec2.model.ModifyVpnTunnelCertificateRequest.wrap(buildAwsValue())
}
object ModifyVpnTunnelCertificateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyVpnTunnelCertificateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyVpnTunnelCertificateRequest =
      zio.aws.ec2.model.ModifyVpnTunnelCertificateRequest(
        vpnConnectionId,
        vpnTunnelOutsideIpAddress
      )
    def vpnConnectionId: VpnConnectionId
    def vpnTunnelOutsideIpAddress: String
    def getVpnConnectionId: ZIO[Any, Nothing, VpnConnectionId] =
      ZIO.succeed(vpnConnectionId)
    def getVpnTunnelOutsideIpAddress: ZIO[Any, Nothing, String] =
      ZIO.succeed(vpnTunnelOutsideIpAddress)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVpnTunnelCertificateRequest
  ) extends zio.aws.ec2.model.ModifyVpnTunnelCertificateRequest.ReadOnly {
    override val vpnConnectionId: VpnConnectionId =
      zio.aws.ec2.model.primitives.VpnConnectionId(impl.vpnConnectionId())
    override val vpnTunnelOutsideIpAddress: String =
      impl.vpnTunnelOutsideIpAddress(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVpnTunnelCertificateRequest
  ): zio.aws.ec2.model.ModifyVpnTunnelCertificateRequest.ReadOnly = new Wrapper(
    impl
  )
}
