package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait IpamScopeType {
  def unwrap: software.amazon.awssdk.services.ec2.model.IpamScopeType
}
object IpamScopeType {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.IpamScopeType
  ): zio.aws.ec2.model.IpamScopeType = value match {
    case software.amazon.awssdk.services.ec2.model.IpamScopeType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.IpamScopeType.PUBLIC =>
      val r = public
      r
    case software.amazon.awssdk.services.ec2.model.IpamScopeType.PRIVATE =>
      val r = `private`
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.IpamScopeType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamScopeType =
      software.amazon.awssdk.services.ec2.model.IpamScopeType.UNKNOWN_TO_SDK_VERSION
  }
  case object public extends zio.aws.ec2.model.IpamScopeType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamScopeType =
      software.amazon.awssdk.services.ec2.model.IpamScopeType.PUBLIC
  }
  case object `private` extends zio.aws.ec2.model.IpamScopeType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.IpamScopeType =
      software.amazon.awssdk.services.ec2.model.IpamScopeType.PRIVATE
  }
}
