package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class IKEVersionsListValue(
    value: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.IKEVersionsListValue = {
    import IKEVersionsListValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.IKEVersionsListValue
      .builder()
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.IKEVersionsListValue.ReadOnly =
    zio.aws.ec2.model.IKEVersionsListValue.wrap(buildAwsValue())
}
object IKEVersionsListValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.IKEVersionsListValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.IKEVersionsListValue =
      zio.aws.ec2.model.IKEVersionsListValue(value.map(value => value))
    def value: Optional[String]
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.IKEVersionsListValue
  ) extends zio.aws.ec2.model.IKEVersionsListValue.ReadOnly {
    override val value: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.IKEVersionsListValue
  ): zio.aws.ec2.model.IKEVersionsListValue.ReadOnly = new Wrapper(impl)
}
