package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{LaunchTemplateName, LaunchTemplateId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FleetLaunchTemplateSpecificationRequest(
    launchTemplateId: Optional[LaunchTemplateId] = Optional.Absent,
    launchTemplateName: Optional[LaunchTemplateName] = Optional.Absent,
    version: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.FleetLaunchTemplateSpecificationRequest = {
    import FleetLaunchTemplateSpecificationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.FleetLaunchTemplateSpecificationRequest
      .builder()
      .optionallyWith(
        launchTemplateId.map(value =>
          LaunchTemplateId.unwrap(value): java.lang.String
        )
      )(_.launchTemplateId)
      .optionallyWith(
        launchTemplateName.map(value =>
          LaunchTemplateName.unwrap(value): java.lang.String
        )
      )(_.launchTemplateName)
      .optionallyWith(version.map(value => value: java.lang.String))(_.version)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.FleetLaunchTemplateSpecificationRequest.ReadOnly =
    zio.aws.ec2.model.FleetLaunchTemplateSpecificationRequest
      .wrap(buildAwsValue())
}
object FleetLaunchTemplateSpecificationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.FleetLaunchTemplateSpecificationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.FleetLaunchTemplateSpecificationRequest =
      zio.aws.ec2.model.FleetLaunchTemplateSpecificationRequest(
        launchTemplateId.map(value => value),
        launchTemplateName.map(value => value),
        version.map(value => value)
      )
    def launchTemplateId: Optional[LaunchTemplateId]
    def launchTemplateName: Optional[LaunchTemplateName]
    def version: Optional[String]
    def getLaunchTemplateId: ZIO[Any, AwsError, LaunchTemplateId] =
      AwsError.unwrapOptionField("launchTemplateId", launchTemplateId)
    def getLaunchTemplateName: ZIO[Any, AwsError, LaunchTemplateName] =
      AwsError.unwrapOptionField("launchTemplateName", launchTemplateName)
    def getVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.FleetLaunchTemplateSpecificationRequest
  ) extends zio.aws.ec2.model.FleetLaunchTemplateSpecificationRequest.ReadOnly {
    override val launchTemplateId: Optional[LaunchTemplateId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.launchTemplateId())
        .map(value => zio.aws.ec2.model.primitives.LaunchTemplateId(value))
    override val launchTemplateName: Optional[LaunchTemplateName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.launchTemplateName())
        .map(value => zio.aws.ec2.model.primitives.LaunchTemplateName(value))
    override val version: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.FleetLaunchTemplateSpecificationRequest
  ): zio.aws.ec2.model.FleetLaunchTemplateSpecificationRequest.ReadOnly =
    new Wrapper(impl)
}
