package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeTransitGatewayMulticastDomainsResponse(
    transitGatewayMulticastDomains: Optional[
      Iterable[zio.aws.ec2.model.TransitGatewayMulticastDomain]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayMulticastDomainsResponse = {
    import DescribeTransitGatewayMulticastDomainsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayMulticastDomainsResponse
      .builder()
      .optionallyWith(
        transitGatewayMulticastDomains.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.transitGatewayMulticastDomains)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeTransitGatewayMulticastDomainsResponse.ReadOnly =
    zio.aws.ec2.model.DescribeTransitGatewayMulticastDomainsResponse
      .wrap(buildAwsValue())
}
object DescribeTransitGatewayMulticastDomainsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayMulticastDomainsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DescribeTransitGatewayMulticastDomainsResponse =
      zio.aws.ec2.model.DescribeTransitGatewayMulticastDomainsResponse(
        transitGatewayMulticastDomains.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def transitGatewayMulticastDomains: Optional[
      List[zio.aws.ec2.model.TransitGatewayMulticastDomain.ReadOnly]
    ]
    def nextToken: Optional[String]
    def getTransitGatewayMulticastDomains: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TransitGatewayMulticastDomain.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "transitGatewayMulticastDomains",
      transitGatewayMulticastDomains
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayMulticastDomainsResponse
  ) extends zio.aws.ec2.model.DescribeTransitGatewayMulticastDomainsResponse.ReadOnly {
    override val transitGatewayMulticastDomains: Optional[
      List[zio.aws.ec2.model.TransitGatewayMulticastDomain.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.transitGatewayMulticastDomains())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.TransitGatewayMulticastDomain.wrap(item)
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayMulticastDomainsResponse
  ): zio.aws.ec2.model.DescribeTransitGatewayMulticastDomainsResponse.ReadOnly =
    new Wrapper(impl)
}
