package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{Integer, VpcFlowLogId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeFlowLogsRequest(
    filter: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent,
    flowLogIds: Optional[Iterable[VpcFlowLogId]] = Optional.Absent,
    maxResults: Optional[Integer] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeFlowLogsRequest = {
    import DescribeFlowLogsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeFlowLogsRequest
      .builder()
      .optionallyWith(
        filter.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filter)
      .optionallyWith(
        flowLogIds.map(value =>
          value.map { item =>
            VpcFlowLogId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.flowLogIds)
      .optionallyWith(maxResults.map(value => value: java.lang.Integer))(
        _.maxResults
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeFlowLogsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeFlowLogsRequest.wrap(buildAwsValue())
}
object DescribeFlowLogsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeFlowLogsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeFlowLogsRequest =
      zio.aws.ec2.model.DescribeFlowLogsRequest(
        filter.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        flowLogIds.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def filter: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def flowLogIds: Optional[List[VpcFlowLogId]]
    def maxResults: Optional[Integer]
    def nextToken: Optional[String]
    def getFilter: ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filter", filter)
    def getFlowLogIds: ZIO[Any, AwsError, List[VpcFlowLogId]] =
      AwsError.unwrapOptionField("flowLogIds", flowLogIds)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeFlowLogsRequest
  ) extends zio.aws.ec2.model.DescribeFlowLogsRequest.ReadOnly {
    override val filter: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filter())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val flowLogIds: Optional[List[VpcFlowLogId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.flowLogIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.VpcFlowLogId(item)
          }.toList
        )
    override val maxResults: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: Integer)
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeFlowLogsRequest
  ): zio.aws.ec2.model.DescribeFlowLogsRequest.ReadOnly = new Wrapper(impl)
}
