package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VpcPeeringConnectionId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteVpcPeeringConnectionRequest(
    vpcPeeringConnectionId: VpcPeeringConnectionId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteVpcPeeringConnectionRequest = {
    import DeleteVpcPeeringConnectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteVpcPeeringConnectionRequest
      .builder()
      .vpcPeeringConnectionId(
        VpcPeeringConnectionId.unwrap(vpcPeeringConnectionId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteVpcPeeringConnectionRequest.ReadOnly =
    zio.aws.ec2.model.DeleteVpcPeeringConnectionRequest.wrap(buildAwsValue())
}
object DeleteVpcPeeringConnectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteVpcPeeringConnectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteVpcPeeringConnectionRequest =
      zio.aws.ec2.model
        .DeleteVpcPeeringConnectionRequest(vpcPeeringConnectionId)
    def vpcPeeringConnectionId: VpcPeeringConnectionId
    def getVpcPeeringConnectionId: ZIO[Any, Nothing, VpcPeeringConnectionId] =
      ZIO.succeed(vpcPeeringConnectionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteVpcPeeringConnectionRequest
  ) extends zio.aws.ec2.model.DeleteVpcPeeringConnectionRequest.ReadOnly {
    override val vpcPeeringConnectionId: VpcPeeringConnectionId =
      zio.aws.ec2.model.primitives
        .VpcPeeringConnectionId(impl.vpcPeeringConnectionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteVpcPeeringConnectionRequest
  ): zio.aws.ec2.model.DeleteVpcPeeringConnectionRequest.ReadOnly = new Wrapper(
    impl
  )
}
