package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.NetworkInsightsAnalysisId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteNetworkInsightsAnalysisRequest(
    networkInsightsAnalysisId: NetworkInsightsAnalysisId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsAnalysisRequest = {
    import DeleteNetworkInsightsAnalysisRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsAnalysisRequest
      .builder()
      .networkInsightsAnalysisId(
        NetworkInsightsAnalysisId.unwrap(
          networkInsightsAnalysisId
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeleteNetworkInsightsAnalysisRequest.ReadOnly =
    zio.aws.ec2.model.DeleteNetworkInsightsAnalysisRequest.wrap(buildAwsValue())
}
object DeleteNetworkInsightsAnalysisRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsAnalysisRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteNetworkInsightsAnalysisRequest =
      zio.aws.ec2.model
        .DeleteNetworkInsightsAnalysisRequest(networkInsightsAnalysisId)
    def networkInsightsAnalysisId: NetworkInsightsAnalysisId
    def getNetworkInsightsAnalysisId
        : ZIO[Any, Nothing, NetworkInsightsAnalysisId] =
      ZIO.succeed(networkInsightsAnalysisId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsAnalysisRequest
  ) extends zio.aws.ec2.model.DeleteNetworkInsightsAnalysisRequest.ReadOnly {
    override val networkInsightsAnalysisId: NetworkInsightsAnalysisId =
      zio.aws.ec2.model.primitives
        .NetworkInsightsAnalysisId(impl.networkInsightsAnalysisId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteNetworkInsightsAnalysisRequest
  ): zio.aws.ec2.model.DeleteNetworkInsightsAnalysisRequest.ReadOnly =
    new Wrapper(impl)
}
