package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteIpamScopeResponse(
    ipamScope: Optional[zio.aws.ec2.model.IpamScope] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteIpamScopeResponse = {
    import DeleteIpamScopeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteIpamScopeResponse
      .builder()
      .optionallyWith(ipamScope.map(value => value.buildAwsValue()))(
        _.ipamScope
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteIpamScopeResponse.ReadOnly =
    zio.aws.ec2.model.DeleteIpamScopeResponse.wrap(buildAwsValue())
}
object DeleteIpamScopeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteIpamScopeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteIpamScopeResponse =
      zio.aws.ec2.model
        .DeleteIpamScopeResponse(ipamScope.map(value => value.asEditable))
    def ipamScope: Optional[zio.aws.ec2.model.IpamScope.ReadOnly]
    def getIpamScope: ZIO[Any, AwsError, zio.aws.ec2.model.IpamScope.ReadOnly] =
      AwsError.unwrapOptionField("ipamScope", ipamScope)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteIpamScopeResponse
  ) extends zio.aws.ec2.model.DeleteIpamScopeResponse.ReadOnly {
    override val ipamScope: Optional[zio.aws.ec2.model.IpamScope.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipamScope())
        .map(value => zio.aws.ec2.model.IpamScope.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteIpamScopeResponse
  ): zio.aws.ec2.model.DeleteIpamScopeResponse.ReadOnly = new Wrapper(impl)
}
