package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  MillisecondDateTime,
  Integer,
  CapacityReservationFleetId
}
import scala.jdk.CollectionConverters._
final case class CreateCapacityReservationFleetResponse(
    capacityReservationFleetId: Optional[CapacityReservationFleetId] =
      Optional.Absent,
    state: Optional[zio.aws.ec2.model.CapacityReservationFleetState] =
      Optional.Absent,
    totalTargetCapacity: Optional[Integer] = Optional.Absent,
    totalFulfilledCapacity: Optional[Double] = Optional.Absent,
    instanceMatchCriteria: Optional[
      zio.aws.ec2.model.FleetInstanceMatchCriteria
    ] = Optional.Absent,
    allocationStrategy: Optional[String] = Optional.Absent,
    createTime: Optional[MillisecondDateTime] = Optional.Absent,
    endDate: Optional[MillisecondDateTime] = Optional.Absent,
    tenancy: Optional[zio.aws.ec2.model.FleetCapacityReservationTenancy] =
      Optional.Absent,
    fleetCapacityReservations: Optional[
      Iterable[zio.aws.ec2.model.FleetCapacityReservation]
    ] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateCapacityReservationFleetResponse = {
    import CreateCapacityReservationFleetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateCapacityReservationFleetResponse
      .builder()
      .optionallyWith(
        capacityReservationFleetId.map(value =>
          CapacityReservationFleetId.unwrap(value): java.lang.String
        )
      )(_.capacityReservationFleetId)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        totalTargetCapacity.map(value => value: java.lang.Integer)
      )(_.totalTargetCapacity)
      .optionallyWith(
        totalFulfilledCapacity.map(value => value: java.lang.Double)
      )(_.totalFulfilledCapacity)
      .optionallyWith(instanceMatchCriteria.map(value => value.unwrap))(
        _.instanceMatchCriteria
      )
      .optionallyWith(allocationStrategy.map(value => value: java.lang.String))(
        _.allocationStrategy
      )
      .optionallyWith(
        createTime.map(value => MillisecondDateTime.unwrap(value): Instant)
      )(_.createTime)
      .optionallyWith(
        endDate.map(value => MillisecondDateTime.unwrap(value): Instant)
      )(_.endDate)
      .optionallyWith(tenancy.map(value => value.unwrap))(_.tenancy)
      .optionallyWith(
        fleetCapacityReservations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fleetCapacityReservations)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CreateCapacityReservationFleetResponse.ReadOnly =
    zio.aws.ec2.model.CreateCapacityReservationFleetResponse
      .wrap(buildAwsValue())
}
object CreateCapacityReservationFleetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateCapacityReservationFleetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateCapacityReservationFleetResponse =
      zio.aws.ec2.model.CreateCapacityReservationFleetResponse(
        capacityReservationFleetId.map(value => value),
        state.map(value => value),
        totalTargetCapacity.map(value => value),
        totalFulfilledCapacity.map(value => value),
        instanceMatchCriteria.map(value => value),
        allocationStrategy.map(value => value),
        createTime.map(value => value),
        endDate.map(value => value),
        tenancy.map(value => value),
        fleetCapacityReservations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def capacityReservationFleetId: Optional[CapacityReservationFleetId]
    def state: Optional[zio.aws.ec2.model.CapacityReservationFleetState]
    def totalTargetCapacity: Optional[Integer]
    def totalFulfilledCapacity: Optional[Double]
    def instanceMatchCriteria
        : Optional[zio.aws.ec2.model.FleetInstanceMatchCriteria]
    def allocationStrategy: Optional[String]
    def createTime: Optional[MillisecondDateTime]
    def endDate: Optional[MillisecondDateTime]
    def tenancy: Optional[zio.aws.ec2.model.FleetCapacityReservationTenancy]
    def fleetCapacityReservations
        : Optional[List[zio.aws.ec2.model.FleetCapacityReservation.ReadOnly]]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getCapacityReservationFleetId
        : ZIO[Any, AwsError, CapacityReservationFleetId] =
      AwsError.unwrapOptionField(
        "capacityReservationFleetId",
        capacityReservationFleetId
      )
    def getState
        : ZIO[Any, AwsError, zio.aws.ec2.model.CapacityReservationFleetState] =
      AwsError.unwrapOptionField("state", state)
    def getTotalTargetCapacity: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("totalTargetCapacity", totalTargetCapacity)
    def getTotalFulfilledCapacity: ZIO[Any, AwsError, Double] = AwsError
      .unwrapOptionField("totalFulfilledCapacity", totalFulfilledCapacity)
    def getInstanceMatchCriteria
        : ZIO[Any, AwsError, zio.aws.ec2.model.FleetInstanceMatchCriteria] =
      AwsError.unwrapOptionField("instanceMatchCriteria", instanceMatchCriteria)
    def getAllocationStrategy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("allocationStrategy", allocationStrategy)
    def getCreateTime: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("createTime", createTime)
    def getEndDate: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("endDate", endDate)
    def getTenancy: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.FleetCapacityReservationTenancy
    ] = AwsError.unwrapOptionField("tenancy", tenancy)
    def getFleetCapacityReservations: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.FleetCapacityReservation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "fleetCapacityReservations",
      fleetCapacityReservations
    )
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateCapacityReservationFleetResponse
  ) extends zio.aws.ec2.model.CreateCapacityReservationFleetResponse.ReadOnly {
    override val capacityReservationFleetId
        : Optional[CapacityReservationFleetId] = zio.aws.core.internal
      .optionalFromNullable(impl.capacityReservationFleetId())
      .map(value =>
        zio.aws.ec2.model.primitives.CapacityReservationFleetId(value)
      )
    override val state
        : Optional[zio.aws.ec2.model.CapacityReservationFleetState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value =>
          zio.aws.ec2.model.CapacityReservationFleetState.wrap(value)
        )
    override val totalTargetCapacity: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.totalTargetCapacity())
      .map(value => value: Integer)
    override val totalFulfilledCapacity: Optional[Double] =
      zio.aws.core.internal
        .optionalFromNullable(impl.totalFulfilledCapacity())
        .map(value => value: Double)
    override val instanceMatchCriteria
        : Optional[zio.aws.ec2.model.FleetInstanceMatchCriteria] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceMatchCriteria())
        .map(value => zio.aws.ec2.model.FleetInstanceMatchCriteria.wrap(value))
    override val allocationStrategy: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.allocationStrategy())
      .map(value => value: String)
    override val createTime: Optional[MillisecondDateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createTime())
        .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val endDate: Optional[MillisecondDateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.endDate())
      .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val tenancy
        : Optional[zio.aws.ec2.model.FleetCapacityReservationTenancy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tenancy())
        .map(value =>
          zio.aws.ec2.model.FleetCapacityReservationTenancy.wrap(value)
        )
    override val fleetCapacityReservations
        : Optional[List[zio.aws.ec2.model.FleetCapacityReservation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fleetCapacityReservations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.FleetCapacityReservation.wrap(item)
          }.toList
        )
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateCapacityReservationFleetResponse
  ): zio.aws.ec2.model.CreateCapacityReservationFleetResponse.ReadOnly =
    new Wrapper(impl)
}
