package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ClientVpnRoute(
    clientVpnEndpointId: Optional[String] = Optional.Absent,
    destinationCidr: Optional[String] = Optional.Absent,
    targetSubnet: Optional[String] = Optional.Absent,
    `type`: Optional[String] = Optional.Absent,
    origin: Optional[String] = Optional.Absent,
    status: Optional[zio.aws.ec2.model.ClientVpnRouteStatus] = Optional.Absent,
    description: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ClientVpnRoute = {
    import ClientVpnRoute.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ClientVpnRoute
      .builder()
      .optionallyWith(
        clientVpnEndpointId.map(value => value: java.lang.String)
      )(_.clientVpnEndpointId)
      .optionallyWith(destinationCidr.map(value => value: java.lang.String))(
        _.destinationCidr
      )
      .optionallyWith(targetSubnet.map(value => value: java.lang.String))(
        _.targetSubnet
      )
      .optionallyWith(`type`.map(value => value: java.lang.String))(_.`type`)
      .optionallyWith(origin.map(value => value: java.lang.String))(_.origin)
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ClientVpnRoute.ReadOnly =
    zio.aws.ec2.model.ClientVpnRoute.wrap(buildAwsValue())
}
object ClientVpnRoute {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ClientVpnRoute
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ClientVpnRoute =
      zio.aws.ec2.model.ClientVpnRoute(
        clientVpnEndpointId.map(value => value),
        destinationCidr.map(value => value),
        targetSubnet.map(value => value),
        `type`.map(value => value),
        origin.map(value => value),
        status.map(value => value.asEditable),
        description.map(value => value)
      )
    def clientVpnEndpointId: Optional[String]
    def destinationCidr: Optional[String]
    def targetSubnet: Optional[String]
    def `type`: Optional[String]
    def origin: Optional[String]
    def status: Optional[zio.aws.ec2.model.ClientVpnRouteStatus.ReadOnly]
    def description: Optional[String]
    def getClientVpnEndpointId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientVpnEndpointId", clientVpnEndpointId)
    def getDestinationCidr: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("destinationCidr", destinationCidr)
    def getTargetSubnet: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("targetSubnet", targetSubnet)
    def getType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("type", `type`)
    def getOrigin: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("origin", origin)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.ec2.model.ClientVpnRouteStatus.ReadOnly] =
      AwsError.unwrapOptionField("status", status)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ClientVpnRoute
  ) extends zio.aws.ec2.model.ClientVpnRoute.ReadOnly {
    override val clientVpnEndpointId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientVpnEndpointId())
      .map(value => value: String)
    override val destinationCidr: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.destinationCidr())
      .map(value => value: String)
    override val targetSubnet: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.targetSubnet())
      .map(value => value: String)
    override val `type`: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => value: String)
    override val origin: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.origin())
      .map(value => value: String)
    override val status
        : Optional[zio.aws.ec2.model.ClientVpnRouteStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.ec2.model.ClientVpnRouteStatus.wrap(value))
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ClientVpnRoute
  ): zio.aws.ec2.model.ClientVpnRoute.ReadOnly = new Wrapper(impl)
}
