package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ClientConnectOptions(
    enabled: Optional[Boolean] = Optional.Absent,
    lambdaFunctionArn: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ClientConnectOptions = {
    import ClientConnectOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ClientConnectOptions
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(lambdaFunctionArn.map(value => value: java.lang.String))(
        _.lambdaFunctionArn
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ClientConnectOptions.ReadOnly =
    zio.aws.ec2.model.ClientConnectOptions.wrap(buildAwsValue())
}
object ClientConnectOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ClientConnectOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ClientConnectOptions =
      zio.aws.ec2.model.ClientConnectOptions(
        enabled.map(value => value),
        lambdaFunctionArn.map(value => value)
      )
    def enabled: Optional[Boolean]
    def lambdaFunctionArn: Optional[String]
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getLambdaFunctionArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("lambdaFunctionArn", lambdaFunctionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ClientConnectOptions
  ) extends zio.aws.ec2.model.ClientConnectOptions.ReadOnly {
    override val enabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: Boolean)
    override val lambdaFunctionArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.lambdaFunctionArn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ClientConnectOptions
  ): zio.aws.ec2.model.ClientConnectOptions.ReadOnly = new Wrapper(impl)
}
