package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ActiveInstance(
    instanceId: Optional[String] = Optional.Absent,
    instanceType: Optional[String] = Optional.Absent,
    spotInstanceRequestId: Optional[String] = Optional.Absent,
    instanceHealth: Optional[zio.aws.ec2.model.InstanceHealthStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ActiveInstance = {
    import ActiveInstance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ActiveInstance
      .builder()
      .optionallyWith(instanceId.map(value => value: java.lang.String))(
        _.instanceId
      )
      .optionallyWith(instanceType.map(value => value: java.lang.String))(
        _.instanceType
      )
      .optionallyWith(
        spotInstanceRequestId.map(value => value: java.lang.String)
      )(_.spotInstanceRequestId)
      .optionallyWith(instanceHealth.map(value => value.unwrap))(
        _.instanceHealth
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ActiveInstance.ReadOnly =
    zio.aws.ec2.model.ActiveInstance.wrap(buildAwsValue())
}
object ActiveInstance {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ActiveInstance
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ActiveInstance =
      zio.aws.ec2.model.ActiveInstance(
        instanceId.map(value => value),
        instanceType.map(value => value),
        spotInstanceRequestId.map(value => value),
        instanceHealth.map(value => value)
      )
    def instanceId: Optional[String]
    def instanceType: Optional[String]
    def spotInstanceRequestId: Optional[String]
    def instanceHealth: Optional[zio.aws.ec2.model.InstanceHealthStatus]
    def getInstanceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getInstanceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getSpotInstanceRequestId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("spotInstanceRequestId", spotInstanceRequestId)
    def getInstanceHealth
        : ZIO[Any, AwsError, zio.aws.ec2.model.InstanceHealthStatus] =
      AwsError.unwrapOptionField("instanceHealth", instanceHealth)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ActiveInstance
  ) extends zio.aws.ec2.model.ActiveInstance.ReadOnly {
    override val instanceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceId())
      .map(value => value: String)
    override val instanceType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceType())
      .map(value => value: String)
    override val spotInstanceRequestId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.spotInstanceRequestId())
      .map(value => value: String)
    override val instanceHealth
        : Optional[zio.aws.ec2.model.InstanceHealthStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceHealth())
        .map(value => zio.aws.ec2.model.InstanceHealthStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ActiveInstance
  ): zio.aws.ec2.model.ActiveInstance.ReadOnly = new Wrapper(impl)
}
