package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TargetGroup(arn: Optional[String] = Optional.Absent) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.TargetGroup = {
    import TargetGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TargetGroup
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.TargetGroup.ReadOnly =
    zio.aws.ec2.model.TargetGroup.wrap(buildAwsValue())
}
object TargetGroup {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.TargetGroup] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TargetGroup =
      zio.aws.ec2.model.TargetGroup(arn.map(value => value))
    def arn: Optional[String]
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TargetGroup
  ) extends zio.aws.ec2.model.TargetGroup.ReadOnly {
    override val arn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TargetGroup
  ): zio.aws.ec2.model.TargetGroup.ReadOnly = new Wrapper(impl)
}
