package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.InstanceId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StopInstancesRequest(
    instanceIds: Iterable[InstanceId],
    hibernate: Optional[Boolean] = Optional.Absent,
    force: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.StopInstancesRequest = {
    import StopInstancesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.StopInstancesRequest
      .builder()
      .instanceIds(instanceIds.map { item =>
        InstanceId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(hibernate.map(value => value: java.lang.Boolean))(
        _.hibernate
      )
      .optionallyWith(force.map(value => value: java.lang.Boolean))(_.force)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.StopInstancesRequest.ReadOnly =
    zio.aws.ec2.model.StopInstancesRequest.wrap(buildAwsValue())
}
object StopInstancesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.StopInstancesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.StopInstancesRequest =
      zio.aws.ec2.model.StopInstancesRequest(
        instanceIds,
        hibernate.map(value => value),
        force.map(value => value)
      )
    def instanceIds: List[InstanceId]
    def hibernate: Optional[Boolean]
    def force: Optional[Boolean]
    def getInstanceIds: ZIO[Any, Nothing, List[InstanceId]] =
      ZIO.succeed(instanceIds)
    def getHibernate: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("hibernate", hibernate)
    def getForce: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("force", force)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.StopInstancesRequest
  ) extends zio.aws.ec2.model.StopInstancesRequest.ReadOnly {
    override val instanceIds: List[InstanceId] = impl
      .instanceIds()
      .asScala
      .map { item =>
        zio.aws.ec2.model.primitives.InstanceId(item)
      }
      .toList
    override val hibernate: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.hibernate())
      .map(value => value: Boolean)
    override val force: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.force())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.StopInstancesRequest
  ): zio.aws.ec2.model.StopInstancesRequest.ReadOnly = new Wrapper(impl)
}
