package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{RouteTableId, RouteTableAssociationId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ReplaceRouteTableAssociationRequest(
    associationId: RouteTableAssociationId,
    routeTableId: RouteTableId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ReplaceRouteTableAssociationRequest = {
    import ReplaceRouteTableAssociationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ReplaceRouteTableAssociationRequest
      .builder()
      .associationId(
        RouteTableAssociationId.unwrap(associationId): java.lang.String
      )
      .routeTableId(RouteTableId.unwrap(routeTableId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ReplaceRouteTableAssociationRequest.ReadOnly =
    zio.aws.ec2.model.ReplaceRouteTableAssociationRequest.wrap(buildAwsValue())
}
object ReplaceRouteTableAssociationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ReplaceRouteTableAssociationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ReplaceRouteTableAssociationRequest =
      zio.aws.ec2.model
        .ReplaceRouteTableAssociationRequest(associationId, routeTableId)
    def associationId: RouteTableAssociationId
    def routeTableId: RouteTableId
    def getAssociationId: ZIO[Any, Nothing, RouteTableAssociationId] =
      ZIO.succeed(associationId)
    def getRouteTableId: ZIO[Any, Nothing, RouteTableId] =
      ZIO.succeed(routeTableId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ReplaceRouteTableAssociationRequest
  ) extends zio.aws.ec2.model.ReplaceRouteTableAssociationRequest.ReadOnly {
    override val associationId: RouteTableAssociationId =
      zio.aws.ec2.model.primitives.RouteTableAssociationId(impl.associationId())
    override val routeTableId: RouteTableId =
      zio.aws.ec2.model.primitives.RouteTableId(impl.routeTableId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ReplaceRouteTableAssociationRequest
  ): zio.aws.ec2.model.ReplaceRouteTableAssociationRequest.ReadOnly =
    new Wrapper(impl)
}
