package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PortRange(
    from: Optional[Integer] = Optional.Absent,
    to: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.PortRange = {
    import PortRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.PortRange
      .builder()
      .optionallyWith(from.map(value => value: java.lang.Integer))(_.from)
      .optionallyWith(to.map(value => value: java.lang.Integer))(_.to)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.PortRange.ReadOnly =
    zio.aws.ec2.model.PortRange.wrap(buildAwsValue())
}
object PortRange {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.PortRange] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.PortRange = zio.aws.ec2.model
      .PortRange(from.map(value => value), to.map(value => value))
    def from: Optional[Integer]
    def to: Optional[Integer]
    def getFrom: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("from", from)
    def getTo: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("to", to)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.PortRange
  ) extends zio.aws.ec2.model.PortRange.ReadOnly {
    override val from: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.from())
      .map(value => value: Integer)
    override val to: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.to())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.PortRange
  ): zio.aws.ec2.model.PortRange.ReadOnly = new Wrapper(impl)
}
