package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{SnapshotId, KmsKeyId, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LaunchTemplateEbsBlockDevice(
    encrypted: Optional[Boolean] = Optional.Absent,
    deleteOnTermination: Optional[Boolean] = Optional.Absent,
    iops: Optional[Integer] = Optional.Absent,
    kmsKeyId: Optional[KmsKeyId] = Optional.Absent,
    snapshotId: Optional[SnapshotId] = Optional.Absent,
    volumeSize: Optional[Integer] = Optional.Absent,
    volumeType: Optional[zio.aws.ec2.model.VolumeType] = Optional.Absent,
    throughput: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.LaunchTemplateEbsBlockDevice = {
    import LaunchTemplateEbsBlockDevice.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.LaunchTemplateEbsBlockDevice
      .builder()
      .optionallyWith(encrypted.map(value => value: java.lang.Boolean))(
        _.encrypted
      )
      .optionallyWith(
        deleteOnTermination.map(value => value: java.lang.Boolean)
      )(_.deleteOnTermination)
      .optionallyWith(iops.map(value => value: java.lang.Integer))(_.iops)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(
        snapshotId.map(value => SnapshotId.unwrap(value): java.lang.String)
      )(_.snapshotId)
      .optionallyWith(volumeSize.map(value => value: java.lang.Integer))(
        _.volumeSize
      )
      .optionallyWith(volumeType.map(value => value.unwrap))(_.volumeType)
      .optionallyWith(throughput.map(value => value: java.lang.Integer))(
        _.throughput
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.LaunchTemplateEbsBlockDevice.ReadOnly =
    zio.aws.ec2.model.LaunchTemplateEbsBlockDevice.wrap(buildAwsValue())
}
object LaunchTemplateEbsBlockDevice {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.LaunchTemplateEbsBlockDevice
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.LaunchTemplateEbsBlockDevice =
      zio.aws.ec2.model.LaunchTemplateEbsBlockDevice(
        encrypted.map(value => value),
        deleteOnTermination.map(value => value),
        iops.map(value => value),
        kmsKeyId.map(value => value),
        snapshotId.map(value => value),
        volumeSize.map(value => value),
        volumeType.map(value => value),
        throughput.map(value => value)
      )
    def encrypted: Optional[Boolean]
    def deleteOnTermination: Optional[Boolean]
    def iops: Optional[Integer]
    def kmsKeyId: Optional[KmsKeyId]
    def snapshotId: Optional[SnapshotId]
    def volumeSize: Optional[Integer]
    def volumeType: Optional[zio.aws.ec2.model.VolumeType]
    def throughput: Optional[Integer]
    def getEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("encrypted", encrypted)
    def getDeleteOnTermination: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("deleteOnTermination", deleteOnTermination)
    def getIops: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("iops", iops)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getSnapshotId: ZIO[Any, AwsError, SnapshotId] =
      AwsError.unwrapOptionField("snapshotId", snapshotId)
    def getVolumeSize: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("volumeSize", volumeSize)
    def getVolumeType: ZIO[Any, AwsError, zio.aws.ec2.model.VolumeType] =
      AwsError.unwrapOptionField("volumeType", volumeType)
    def getThroughput: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("throughput", throughput)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.LaunchTemplateEbsBlockDevice
  ) extends zio.aws.ec2.model.LaunchTemplateEbsBlockDevice.ReadOnly {
    override val encrypted: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.encrypted())
      .map(value => value: Boolean)
    override val deleteOnTermination: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.deleteOnTermination())
      .map(value => value: Boolean)
    override val iops: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.iops())
      .map(value => value: Integer)
    override val kmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.ec2.model.primitives.KmsKeyId(value))
    override val snapshotId: Optional[SnapshotId] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotId())
      .map(value => zio.aws.ec2.model.primitives.SnapshotId(value))
    override val volumeSize: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeSize())
      .map(value => value: Integer)
    override val volumeType: Optional[zio.aws.ec2.model.VolumeType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.volumeType())
        .map(value => zio.aws.ec2.model.VolumeType.wrap(value))
    override val throughput: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.throughput())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.LaunchTemplateEbsBlockDevice
  ): zio.aws.ec2.model.LaunchTemplateEbsBlockDevice.ReadOnly = new Wrapper(impl)
}
