package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{Integer, ResourceArn, IpamScopeId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class IpamScope(
    ownerId: Optional[String] = Optional.Absent,
    ipamScopeId: Optional[IpamScopeId] = Optional.Absent,
    ipamScopeArn: Optional[ResourceArn] = Optional.Absent,
    ipamArn: Optional[ResourceArn] = Optional.Absent,
    ipamRegion: Optional[String] = Optional.Absent,
    ipamScopeType: Optional[zio.aws.ec2.model.IpamScopeType] = Optional.Absent,
    isDefault: Optional[Boolean] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    poolCount: Optional[Integer] = Optional.Absent,
    state: Optional[zio.aws.ec2.model.IpamScopeState] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.IpamScope = {
    import IpamScope.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.IpamScope
      .builder()
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .optionallyWith(
        ipamScopeId.map(value => IpamScopeId.unwrap(value): java.lang.String)
      )(_.ipamScopeId)
      .optionallyWith(
        ipamScopeArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.ipamScopeArn)
      .optionallyWith(
        ipamArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.ipamArn)
      .optionallyWith(ipamRegion.map(value => value: java.lang.String))(
        _.ipamRegion
      )
      .optionallyWith(ipamScopeType.map(value => value.unwrap))(_.ipamScopeType)
      .optionallyWith(isDefault.map(value => value: java.lang.Boolean))(
        _.isDefault
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(poolCount.map(value => value: java.lang.Integer))(
        _.poolCount
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.IpamScope.ReadOnly =
    zio.aws.ec2.model.IpamScope.wrap(buildAwsValue())
}
object IpamScope {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.IpamScope] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.IpamScope = zio.aws.ec2.model.IpamScope(
      ownerId.map(value => value),
      ipamScopeId.map(value => value),
      ipamScopeArn.map(value => value),
      ipamArn.map(value => value),
      ipamRegion.map(value => value),
      ipamScopeType.map(value => value),
      isDefault.map(value => value),
      description.map(value => value),
      poolCount.map(value => value),
      state.map(value => value),
      tags.map(value =>
        value.map { item =>
          item.asEditable
        }
      )
    )
    def ownerId: Optional[String]
    def ipamScopeId: Optional[IpamScopeId]
    def ipamScopeArn: Optional[ResourceArn]
    def ipamArn: Optional[ResourceArn]
    def ipamRegion: Optional[String]
    def ipamScopeType: Optional[zio.aws.ec2.model.IpamScopeType]
    def isDefault: Optional[Boolean]
    def description: Optional[String]
    def poolCount: Optional[Integer]
    def state: Optional[zio.aws.ec2.model.IpamScopeState]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getIpamScopeId: ZIO[Any, AwsError, IpamScopeId] =
      AwsError.unwrapOptionField("ipamScopeId", ipamScopeId)
    def getIpamScopeArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("ipamScopeArn", ipamScopeArn)
    def getIpamArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("ipamArn", ipamArn)
    def getIpamRegion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ipamRegion", ipamRegion)
    def getIpamScopeType: ZIO[Any, AwsError, zio.aws.ec2.model.IpamScopeType] =
      AwsError.unwrapOptionField("ipamScopeType", ipamScopeType)
    def getIsDefault: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isDefault", isDefault)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getPoolCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("poolCount", poolCount)
    def getState: ZIO[Any, AwsError, zio.aws.ec2.model.IpamScopeState] =
      AwsError.unwrapOptionField("state", state)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.IpamScope
  ) extends zio.aws.ec2.model.IpamScope.ReadOnly {
    override val ownerId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerId())
      .map(value => value: String)
    override val ipamScopeId: Optional[IpamScopeId] = zio.aws.core.internal
      .optionalFromNullable(impl.ipamScopeId())
      .map(value => zio.aws.ec2.model.primitives.IpamScopeId(value))
    override val ipamScopeArn: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.ipamScopeArn())
      .map(value => zio.aws.ec2.model.primitives.ResourceArn(value))
    override val ipamArn: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.ipamArn())
      .map(value => zio.aws.ec2.model.primitives.ResourceArn(value))
    override val ipamRegion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ipamRegion())
      .map(value => value: String)
    override val ipamScopeType: Optional[zio.aws.ec2.model.IpamScopeType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipamScopeType())
        .map(value => zio.aws.ec2.model.IpamScopeType.wrap(value))
    override val isDefault: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isDefault())
      .map(value => value: Boolean)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val poolCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.poolCount())
      .map(value => value: Integer)
    override val state: Optional[zio.aws.ec2.model.IpamScopeState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.ec2.model.IpamScopeState.wrap(value))
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.IpamScope
  ): zio.aws.ec2.model.IpamScope.ReadOnly = new Wrapper(impl)
}
