package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  IpamNetmaskLength,
  Integer,
  ResourceArn,
  IpamPoolId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class IpamPool(
    ownerId: Optional[String] = Optional.Absent,
    ipamPoolId: Optional[IpamPoolId] = Optional.Absent,
    sourceIpamPoolId: Optional[IpamPoolId] = Optional.Absent,
    ipamPoolArn: Optional[ResourceArn] = Optional.Absent,
    ipamScopeArn: Optional[ResourceArn] = Optional.Absent,
    ipamScopeType: Optional[zio.aws.ec2.model.IpamScopeType] = Optional.Absent,
    ipamArn: Optional[ResourceArn] = Optional.Absent,
    ipamRegion: Optional[String] = Optional.Absent,
    locale: Optional[String] = Optional.Absent,
    poolDepth: Optional[Integer] = Optional.Absent,
    state: Optional[zio.aws.ec2.model.IpamPoolState] = Optional.Absent,
    stateMessage: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    autoImport: Optional[Boolean] = Optional.Absent,
    publiclyAdvertisable: Optional[Boolean] = Optional.Absent,
    addressFamily: Optional[zio.aws.ec2.model.AddressFamily] = Optional.Absent,
    allocationMinNetmaskLength: Optional[IpamNetmaskLength] = Optional.Absent,
    allocationMaxNetmaskLength: Optional[IpamNetmaskLength] = Optional.Absent,
    allocationDefaultNetmaskLength: Optional[IpamNetmaskLength] =
      Optional.Absent,
    allocationResourceTags: Optional[
      Iterable[zio.aws.ec2.model.IpamResourceTag]
    ] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent,
    awsService: Optional[zio.aws.ec2.model.IpamPoolAwsService] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.IpamPool = {
    import IpamPool.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.IpamPool
      .builder()
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .optionallyWith(
        ipamPoolId.map(value => IpamPoolId.unwrap(value): java.lang.String)
      )(_.ipamPoolId)
      .optionallyWith(
        sourceIpamPoolId.map(value =>
          IpamPoolId.unwrap(value): java.lang.String
        )
      )(_.sourceIpamPoolId)
      .optionallyWith(
        ipamPoolArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.ipamPoolArn)
      .optionallyWith(
        ipamScopeArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.ipamScopeArn)
      .optionallyWith(ipamScopeType.map(value => value.unwrap))(_.ipamScopeType)
      .optionallyWith(
        ipamArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.ipamArn)
      .optionallyWith(ipamRegion.map(value => value: java.lang.String))(
        _.ipamRegion
      )
      .optionallyWith(locale.map(value => value: java.lang.String))(_.locale)
      .optionallyWith(poolDepth.map(value => value: java.lang.Integer))(
        _.poolDepth
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(stateMessage.map(value => value: java.lang.String))(
        _.stateMessage
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(autoImport.map(value => value: java.lang.Boolean))(
        _.autoImport
      )
      .optionallyWith(
        publiclyAdvertisable.map(value => value: java.lang.Boolean)
      )(_.publiclyAdvertisable)
      .optionallyWith(addressFamily.map(value => value.unwrap))(_.addressFamily)
      .optionallyWith(
        allocationMinNetmaskLength.map(value =>
          IpamNetmaskLength.unwrap(value): java.lang.Integer
        )
      )(_.allocationMinNetmaskLength)
      .optionallyWith(
        allocationMaxNetmaskLength.map(value =>
          IpamNetmaskLength.unwrap(value): java.lang.Integer
        )
      )(_.allocationMaxNetmaskLength)
      .optionallyWith(
        allocationDefaultNetmaskLength.map(value =>
          IpamNetmaskLength.unwrap(value): java.lang.Integer
        )
      )(_.allocationDefaultNetmaskLength)
      .optionallyWith(
        allocationResourceTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.allocationResourceTags)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(awsService.map(value => value.unwrap))(_.awsService)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.IpamPool.ReadOnly =
    zio.aws.ec2.model.IpamPool.wrap(buildAwsValue())
}
object IpamPool {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.IpamPool] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.IpamPool = zio.aws.ec2.model.IpamPool(
      ownerId.map(value => value),
      ipamPoolId.map(value => value),
      sourceIpamPoolId.map(value => value),
      ipamPoolArn.map(value => value),
      ipamScopeArn.map(value => value),
      ipamScopeType.map(value => value),
      ipamArn.map(value => value),
      ipamRegion.map(value => value),
      locale.map(value => value),
      poolDepth.map(value => value),
      state.map(value => value),
      stateMessage.map(value => value),
      description.map(value => value),
      autoImport.map(value => value),
      publiclyAdvertisable.map(value => value),
      addressFamily.map(value => value),
      allocationMinNetmaskLength.map(value => value),
      allocationMaxNetmaskLength.map(value => value),
      allocationDefaultNetmaskLength.map(value => value),
      allocationResourceTags.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      tags.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      awsService.map(value => value)
    )
    def ownerId: Optional[String]
    def ipamPoolId: Optional[IpamPoolId]
    def sourceIpamPoolId: Optional[IpamPoolId]
    def ipamPoolArn: Optional[ResourceArn]
    def ipamScopeArn: Optional[ResourceArn]
    def ipamScopeType: Optional[zio.aws.ec2.model.IpamScopeType]
    def ipamArn: Optional[ResourceArn]
    def ipamRegion: Optional[String]
    def locale: Optional[String]
    def poolDepth: Optional[Integer]
    def state: Optional[zio.aws.ec2.model.IpamPoolState]
    def stateMessage: Optional[String]
    def description: Optional[String]
    def autoImport: Optional[Boolean]
    def publiclyAdvertisable: Optional[Boolean]
    def addressFamily: Optional[zio.aws.ec2.model.AddressFamily]
    def allocationMinNetmaskLength: Optional[IpamNetmaskLength]
    def allocationMaxNetmaskLength: Optional[IpamNetmaskLength]
    def allocationDefaultNetmaskLength: Optional[IpamNetmaskLength]
    def allocationResourceTags
        : Optional[List[zio.aws.ec2.model.IpamResourceTag.ReadOnly]]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def awsService: Optional[zio.aws.ec2.model.IpamPoolAwsService]
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getIpamPoolId: ZIO[Any, AwsError, IpamPoolId] =
      AwsError.unwrapOptionField("ipamPoolId", ipamPoolId)
    def getSourceIpamPoolId: ZIO[Any, AwsError, IpamPoolId] =
      AwsError.unwrapOptionField("sourceIpamPoolId", sourceIpamPoolId)
    def getIpamPoolArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("ipamPoolArn", ipamPoolArn)
    def getIpamScopeArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("ipamScopeArn", ipamScopeArn)
    def getIpamScopeType: ZIO[Any, AwsError, zio.aws.ec2.model.IpamScopeType] =
      AwsError.unwrapOptionField("ipamScopeType", ipamScopeType)
    def getIpamArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("ipamArn", ipamArn)
    def getIpamRegion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ipamRegion", ipamRegion)
    def getLocale: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("locale", locale)
    def getPoolDepth: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("poolDepth", poolDepth)
    def getState: ZIO[Any, AwsError, zio.aws.ec2.model.IpamPoolState] =
      AwsError.unwrapOptionField("state", state)
    def getStateMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("stateMessage", stateMessage)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getAutoImport: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("autoImport", autoImport)
    def getPubliclyAdvertisable: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("publiclyAdvertisable", publiclyAdvertisable)
    def getAddressFamily: ZIO[Any, AwsError, zio.aws.ec2.model.AddressFamily] =
      AwsError.unwrapOptionField("addressFamily", addressFamily)
    def getAllocationMinNetmaskLength: ZIO[Any, AwsError, IpamNetmaskLength] =
      AwsError.unwrapOptionField(
        "allocationMinNetmaskLength",
        allocationMinNetmaskLength
      )
    def getAllocationMaxNetmaskLength: ZIO[Any, AwsError, IpamNetmaskLength] =
      AwsError.unwrapOptionField(
        "allocationMaxNetmaskLength",
        allocationMaxNetmaskLength
      )
    def getAllocationDefaultNetmaskLength
        : ZIO[Any, AwsError, IpamNetmaskLength] = AwsError.unwrapOptionField(
      "allocationDefaultNetmaskLength",
      allocationDefaultNetmaskLength
    )
    def getAllocationResourceTags
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.IpamResourceTag.ReadOnly]] =
      AwsError.unwrapOptionField(
        "allocationResourceTags",
        allocationResourceTags
      )
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getAwsService
        : ZIO[Any, AwsError, zio.aws.ec2.model.IpamPoolAwsService] =
      AwsError.unwrapOptionField("awsService", awsService)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.IpamPool
  ) extends zio.aws.ec2.model.IpamPool.ReadOnly {
    override val ownerId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerId())
      .map(value => value: String)
    override val ipamPoolId: Optional[IpamPoolId] = zio.aws.core.internal
      .optionalFromNullable(impl.ipamPoolId())
      .map(value => zio.aws.ec2.model.primitives.IpamPoolId(value))
    override val sourceIpamPoolId: Optional[IpamPoolId] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceIpamPoolId())
      .map(value => zio.aws.ec2.model.primitives.IpamPoolId(value))
    override val ipamPoolArn: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.ipamPoolArn())
      .map(value => zio.aws.ec2.model.primitives.ResourceArn(value))
    override val ipamScopeArn: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.ipamScopeArn())
      .map(value => zio.aws.ec2.model.primitives.ResourceArn(value))
    override val ipamScopeType: Optional[zio.aws.ec2.model.IpamScopeType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipamScopeType())
        .map(value => zio.aws.ec2.model.IpamScopeType.wrap(value))
    override val ipamArn: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.ipamArn())
      .map(value => zio.aws.ec2.model.primitives.ResourceArn(value))
    override val ipamRegion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ipamRegion())
      .map(value => value: String)
    override val locale: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.locale())
      .map(value => value: String)
    override val poolDepth: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.poolDepth())
      .map(value => value: Integer)
    override val state: Optional[zio.aws.ec2.model.IpamPoolState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.ec2.model.IpamPoolState.wrap(value))
    override val stateMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.stateMessage())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val autoImport: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.autoImport())
      .map(value => value: Boolean)
    override val publiclyAdvertisable: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.publiclyAdvertisable())
      .map(value => value: Boolean)
    override val addressFamily: Optional[zio.aws.ec2.model.AddressFamily] =
      zio.aws.core.internal
        .optionalFromNullable(impl.addressFamily())
        .map(value => zio.aws.ec2.model.AddressFamily.wrap(value))
    override val allocationMinNetmaskLength: Optional[IpamNetmaskLength] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allocationMinNetmaskLength())
        .map(value => zio.aws.ec2.model.primitives.IpamNetmaskLength(value))
    override val allocationMaxNetmaskLength: Optional[IpamNetmaskLength] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allocationMaxNetmaskLength())
        .map(value => zio.aws.ec2.model.primitives.IpamNetmaskLength(value))
    override val allocationDefaultNetmaskLength: Optional[IpamNetmaskLength] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allocationDefaultNetmaskLength())
        .map(value => zio.aws.ec2.model.primitives.IpamNetmaskLength(value))
    override val allocationResourceTags
        : Optional[List[zio.aws.ec2.model.IpamResourceTag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allocationResourceTags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.IpamResourceTag.wrap(item)
          }.toList
        )
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
    override val awsService: Optional[zio.aws.ec2.model.IpamPoolAwsService] =
      zio.aws.core.internal
        .optionalFromNullable(impl.awsService())
        .map(value => zio.aws.ec2.model.IpamPoolAwsService.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.IpamPool
  ): zio.aws.ec2.model.IpamPool.ReadOnly = new Wrapper(impl)
}
