package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class IpRange(
    cidrIp: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.IpRange = {
    import IpRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.IpRange
      .builder()
      .optionallyWith(cidrIp.map(value => value: java.lang.String))(_.cidrIp)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.IpRange.ReadOnly =
    zio.aws.ec2.model.IpRange.wrap(buildAwsValue())
}
object IpRange {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.IpRange] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.IpRange = zio.aws.ec2.model
      .IpRange(cidrIp.map(value => value), description.map(value => value))
    def cidrIp: Optional[String]
    def description: Optional[String]
    def getCidrIp: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cidrIp", cidrIp)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.IpRange
  ) extends zio.aws.ec2.model.IpRange.ReadOnly {
    override val cidrIp: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cidrIp())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.IpRange
  ): zio.aws.ec2.model.IpRange.ReadOnly = new Wrapper(impl)
}
