package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetTransitGatewayMulticastDomainAssociationsResponse(
    multicastDomainAssociations: Optional[
      Iterable[zio.aws.ec2.model.TransitGatewayMulticastDomainAssociation]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetTransitGatewayMulticastDomainAssociationsResponse = {
    import GetTransitGatewayMulticastDomainAssociationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetTransitGatewayMulticastDomainAssociationsResponse
      .builder()
      .optionallyWith(
        multicastDomainAssociations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.multicastDomainAssociations)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.GetTransitGatewayMulticastDomainAssociationsResponse.ReadOnly =
    zio.aws.ec2.model.GetTransitGatewayMulticastDomainAssociationsResponse
      .wrap(buildAwsValue())
}
object GetTransitGatewayMulticastDomainAssociationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetTransitGatewayMulticastDomainAssociationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.GetTransitGatewayMulticastDomainAssociationsResponse =
      zio.aws.ec2.model.GetTransitGatewayMulticastDomainAssociationsResponse(
        multicastDomainAssociations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def multicastDomainAssociations: Optional[
      List[zio.aws.ec2.model.TransitGatewayMulticastDomainAssociation.ReadOnly]
    ]
    def nextToken: Optional[String]
    def getMulticastDomainAssociations: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TransitGatewayMulticastDomainAssociation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "multicastDomainAssociations",
      multicastDomainAssociations
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetTransitGatewayMulticastDomainAssociationsResponse
  ) extends zio.aws.ec2.model.GetTransitGatewayMulticastDomainAssociationsResponse.ReadOnly {
    override val multicastDomainAssociations: Optional[
      List[zio.aws.ec2.model.TransitGatewayMulticastDomainAssociation.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.multicastDomainAssociations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.TransitGatewayMulticastDomainAssociation.wrap(item)
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetTransitGatewayMulticastDomainAssociationsResponse
  ): zio.aws.ec2.model.GetTransitGatewayMulticastDomainAssociationsResponse.ReadOnly =
    new Wrapper(impl)
}
