package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  Ipv6PoolMaxResults,
  NextToken,
  Ipv6PoolEc2Id
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetAssociatedIpv6PoolCidrsRequest(
    poolId: Ipv6PoolEc2Id,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[Ipv6PoolMaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetAssociatedIpv6PoolCidrsRequest = {
    import GetAssociatedIpv6PoolCidrsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetAssociatedIpv6PoolCidrsRequest
      .builder()
      .poolId(Ipv6PoolEc2Id.unwrap(poolId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => Ipv6PoolMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.GetAssociatedIpv6PoolCidrsRequest.ReadOnly =
    zio.aws.ec2.model.GetAssociatedIpv6PoolCidrsRequest.wrap(buildAwsValue())
}
object GetAssociatedIpv6PoolCidrsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetAssociatedIpv6PoolCidrsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GetAssociatedIpv6PoolCidrsRequest =
      zio.aws.ec2.model.GetAssociatedIpv6PoolCidrsRequest(
        poolId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def poolId: Ipv6PoolEc2Id
    def nextToken: Optional[NextToken]
    def maxResults: Optional[Ipv6PoolMaxResults]
    def getPoolId: ZIO[Any, Nothing, Ipv6PoolEc2Id] = ZIO.succeed(poolId)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, Ipv6PoolMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetAssociatedIpv6PoolCidrsRequest
  ) extends zio.aws.ec2.model.GetAssociatedIpv6PoolCidrsRequest.ReadOnly {
    override val poolId: Ipv6PoolEc2Id =
      zio.aws.ec2.model.primitives.Ipv6PoolEc2Id(impl.poolId())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
    override val maxResults: Optional[Ipv6PoolMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value => zio.aws.ec2.model.primitives.Ipv6PoolMaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetAssociatedIpv6PoolCidrsRequest
  ): zio.aws.ec2.model.GetAssociatedIpv6PoolCidrsRequest.ReadOnly = new Wrapper(
    impl
  )
}
