package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.DateTime
import scala.jdk.CollectionConverters._
final case class FpgaImage(
    fpgaImageId: Optional[String] = Optional.Absent,
    fpgaImageGlobalId: Optional[String] = Optional.Absent,
    name: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    shellVersion: Optional[String] = Optional.Absent,
    pciId: Optional[zio.aws.ec2.model.PciId] = Optional.Absent,
    state: Optional[zio.aws.ec2.model.FpgaImageState] = Optional.Absent,
    createTime: Optional[DateTime] = Optional.Absent,
    updateTime: Optional[DateTime] = Optional.Absent,
    ownerId: Optional[String] = Optional.Absent,
    ownerAlias: Optional[String] = Optional.Absent,
    productCodes: Optional[Iterable[zio.aws.ec2.model.ProductCode]] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent,
    isPublic: Optional[Boolean] = Optional.Absent,
    dataRetentionSupport: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.FpgaImage = {
    import FpgaImage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.FpgaImage
      .builder()
      .optionallyWith(fpgaImageId.map(value => value: java.lang.String))(
        _.fpgaImageId
      )
      .optionallyWith(fpgaImageGlobalId.map(value => value: java.lang.String))(
        _.fpgaImageGlobalId
      )
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(shellVersion.map(value => value: java.lang.String))(
        _.shellVersion
      )
      .optionallyWith(pciId.map(value => value.buildAwsValue()))(_.pciId)
      .optionallyWith(state.map(value => value.buildAwsValue()))(_.state)
      .optionallyWith(createTime.map(value => DateTime.unwrap(value): Instant))(
        _.createTime
      )
      .optionallyWith(updateTime.map(value => DateTime.unwrap(value): Instant))(
        _.updateTime
      )
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .optionallyWith(ownerAlias.map(value => value: java.lang.String))(
        _.ownerAlias
      )
      .optionallyWith(
        productCodes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.productCodes)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(isPublic.map(value => value: java.lang.Boolean))(
        _.isPublic
      )
      .optionallyWith(
        dataRetentionSupport.map(value => value: java.lang.Boolean)
      )(_.dataRetentionSupport)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.FpgaImage.ReadOnly =
    zio.aws.ec2.model.FpgaImage.wrap(buildAwsValue())
}
object FpgaImage {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.FpgaImage] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.FpgaImage = zio.aws.ec2.model.FpgaImage(
      fpgaImageId.map(value => value),
      fpgaImageGlobalId.map(value => value),
      name.map(value => value),
      description.map(value => value),
      shellVersion.map(value => value),
      pciId.map(value => value.asEditable),
      state.map(value => value.asEditable),
      createTime.map(value => value),
      updateTime.map(value => value),
      ownerId.map(value => value),
      ownerAlias.map(value => value),
      productCodes.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      tags.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      isPublic.map(value => value),
      dataRetentionSupport.map(value => value)
    )
    def fpgaImageId: Optional[String]
    def fpgaImageGlobalId: Optional[String]
    def name: Optional[String]
    def description: Optional[String]
    def shellVersion: Optional[String]
    def pciId: Optional[zio.aws.ec2.model.PciId.ReadOnly]
    def state: Optional[zio.aws.ec2.model.FpgaImageState.ReadOnly]
    def createTime: Optional[DateTime]
    def updateTime: Optional[DateTime]
    def ownerId: Optional[String]
    def ownerAlias: Optional[String]
    def productCodes: Optional[List[zio.aws.ec2.model.ProductCode.ReadOnly]]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def isPublic: Optional[Boolean]
    def dataRetentionSupport: Optional[Boolean]
    def getFpgaImageId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("fpgaImageId", fpgaImageId)
    def getFpgaImageGlobalId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("fpgaImageGlobalId", fpgaImageGlobalId)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getShellVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("shellVersion", shellVersion)
    def getPciId: ZIO[Any, AwsError, zio.aws.ec2.model.PciId.ReadOnly] =
      AwsError.unwrapOptionField("pciId", pciId)
    def getState
        : ZIO[Any, AwsError, zio.aws.ec2.model.FpgaImageState.ReadOnly] =
      AwsError.unwrapOptionField("state", state)
    def getCreateTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("createTime", createTime)
    def getUpdateTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("updateTime", updateTime)
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getOwnerAlias: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerAlias", ownerAlias)
    def getProductCodes
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.ProductCode.ReadOnly]] =
      AwsError.unwrapOptionField("productCodes", productCodes)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getIsPublic: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isPublic", isPublic)
    def getDataRetentionSupport: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dataRetentionSupport", dataRetentionSupport)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.FpgaImage
  ) extends zio.aws.ec2.model.FpgaImage.ReadOnly {
    override val fpgaImageId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.fpgaImageId())
      .map(value => value: String)
    override val fpgaImageGlobalId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.fpgaImageGlobalId())
      .map(value => value: String)
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val shellVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.shellVersion())
      .map(value => value: String)
    override val pciId: Optional[zio.aws.ec2.model.PciId.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pciId())
        .map(value => zio.aws.ec2.model.PciId.wrap(value))
    override val state: Optional[zio.aws.ec2.model.FpgaImageState.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.ec2.model.FpgaImageState.wrap(value))
    override val createTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.createTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val updateTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.updateTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val ownerId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerId())
      .map(value => value: String)
    override val ownerAlias: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerAlias())
      .map(value => value: String)
    override val productCodes
        : Optional[List[zio.aws.ec2.model.ProductCode.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.productCodes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.ProductCode.wrap(item)
          }.toList
        )
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
    override val isPublic: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isPublic())
      .map(value => value: Boolean)
    override val dataRetentionSupport: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dataRetentionSupport())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.FpgaImage
  ): zio.aws.ec2.model.FpgaImage.ReadOnly = new Wrapper(impl)
}
