package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FleetLaunchTemplateOverrides(
    instanceType: Optional[zio.aws.ec2.model.InstanceType] = Optional.Absent,
    maxPrice: Optional[String] = Optional.Absent,
    subnetId: Optional[String] = Optional.Absent,
    availabilityZone: Optional[String] = Optional.Absent,
    weightedCapacity: Optional[Double] = Optional.Absent,
    priority: Optional[Double] = Optional.Absent,
    placement: Optional[zio.aws.ec2.model.PlacementResponse] = Optional.Absent,
    instanceRequirements: Optional[zio.aws.ec2.model.InstanceRequirements] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.FleetLaunchTemplateOverrides = {
    import FleetLaunchTemplateOverrides.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.FleetLaunchTemplateOverrides
      .builder()
      .optionallyWith(instanceType.map(value => value.unwrap))(_.instanceType)
      .optionallyWith(maxPrice.map(value => value: java.lang.String))(
        _.maxPrice
      )
      .optionallyWith(subnetId.map(value => value: java.lang.String))(
        _.subnetId
      )
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(weightedCapacity.map(value => value: java.lang.Double))(
        _.weightedCapacity
      )
      .optionallyWith(priority.map(value => value: java.lang.Double))(
        _.priority
      )
      .optionallyWith(placement.map(value => value.buildAwsValue()))(
        _.placement
      )
      .optionallyWith(instanceRequirements.map(value => value.buildAwsValue()))(
        _.instanceRequirements
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.FleetLaunchTemplateOverrides.ReadOnly =
    zio.aws.ec2.model.FleetLaunchTemplateOverrides.wrap(buildAwsValue())
}
object FleetLaunchTemplateOverrides {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.FleetLaunchTemplateOverrides
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.FleetLaunchTemplateOverrides =
      zio.aws.ec2.model.FleetLaunchTemplateOverrides(
        instanceType.map(value => value),
        maxPrice.map(value => value),
        subnetId.map(value => value),
        availabilityZone.map(value => value),
        weightedCapacity.map(value => value),
        priority.map(value => value),
        placement.map(value => value.asEditable),
        instanceRequirements.map(value => value.asEditable)
      )
    def instanceType: Optional[zio.aws.ec2.model.InstanceType]
    def maxPrice: Optional[String]
    def subnetId: Optional[String]
    def availabilityZone: Optional[String]
    def weightedCapacity: Optional[Double]
    def priority: Optional[Double]
    def placement: Optional[zio.aws.ec2.model.PlacementResponse.ReadOnly]
    def instanceRequirements
        : Optional[zio.aws.ec2.model.InstanceRequirements.ReadOnly]
    def getInstanceType: ZIO[Any, AwsError, zio.aws.ec2.model.InstanceType] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getMaxPrice: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("maxPrice", maxPrice)
    def getSubnetId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subnetId", subnetId)
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getWeightedCapacity: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("weightedCapacity", weightedCapacity)
    def getPriority: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("priority", priority)
    def getPlacement
        : ZIO[Any, AwsError, zio.aws.ec2.model.PlacementResponse.ReadOnly] =
      AwsError.unwrapOptionField("placement", placement)
    def getInstanceRequirements
        : ZIO[Any, AwsError, zio.aws.ec2.model.InstanceRequirements.ReadOnly] =
      AwsError.unwrapOptionField("instanceRequirements", instanceRequirements)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.FleetLaunchTemplateOverrides
  ) extends zio.aws.ec2.model.FleetLaunchTemplateOverrides.ReadOnly {
    override val instanceType: Optional[zio.aws.ec2.model.InstanceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceType())
        .map(value => zio.aws.ec2.model.InstanceType.wrap(value))
    override val maxPrice: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.maxPrice())
      .map(value => value: String)
    override val subnetId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetId())
      .map(value => value: String)
    override val availabilityZone: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZone())
      .map(value => value: String)
    override val weightedCapacity: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.weightedCapacity())
      .map(value => value: Double)
    override val priority: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.priority())
      .map(value => value: Double)
    override val placement
        : Optional[zio.aws.ec2.model.PlacementResponse.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.placement())
        .map(value => zio.aws.ec2.model.PlacementResponse.wrap(value))
    override val instanceRequirements
        : Optional[zio.aws.ec2.model.InstanceRequirements.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceRequirements())
        .map(value => zio.aws.ec2.model.InstanceRequirements.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.FleetLaunchTemplateOverrides
  ): zio.aws.ec2.model.FleetLaunchTemplateOverrides.ReadOnly = new Wrapper(impl)
}
