package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeVpcEndpointConnectionsResponse(
    vpcEndpointConnections: Optional[
      Iterable[zio.aws.ec2.model.VpcEndpointConnection]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointConnectionsResponse = {
    import DescribeVpcEndpointConnectionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointConnectionsResponse
      .builder()
      .optionallyWith(
        vpcEndpointConnections.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vpcEndpointConnections)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeVpcEndpointConnectionsResponse.ReadOnly =
    zio.aws.ec2.model.DescribeVpcEndpointConnectionsResponse
      .wrap(buildAwsValue())
}
object DescribeVpcEndpointConnectionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointConnectionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeVpcEndpointConnectionsResponse =
      zio.aws.ec2.model.DescribeVpcEndpointConnectionsResponse(
        vpcEndpointConnections.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def vpcEndpointConnections
        : Optional[List[zio.aws.ec2.model.VpcEndpointConnection.ReadOnly]]
    def nextToken: Optional[String]
    def getVpcEndpointConnections: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.VpcEndpointConnection.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "vpcEndpointConnections",
      vpcEndpointConnections
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointConnectionsResponse
  ) extends zio.aws.ec2.model.DescribeVpcEndpointConnectionsResponse.ReadOnly {
    override val vpcEndpointConnections
        : Optional[List[zio.aws.ec2.model.VpcEndpointConnection.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcEndpointConnections())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.VpcEndpointConnection.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointConnectionsResponse
  ): zio.aws.ec2.model.DescribeVpcEndpointConnectionsResponse.ReadOnly =
    new Wrapper(impl)
}
