package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeLocalGatewayRouteTableVpcAssociationsResponse(
    localGatewayRouteTableVpcAssociations: Optional[
      Iterable[zio.aws.ec2.model.LocalGatewayRouteTableVpcAssociation]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTableVpcAssociationsResponse = {
    import DescribeLocalGatewayRouteTableVpcAssociationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTableVpcAssociationsResponse
      .builder()
      .optionallyWith(
        localGatewayRouteTableVpcAssociations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.localGatewayRouteTableVpcAssociations)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeLocalGatewayRouteTableVpcAssociationsResponse.ReadOnly =
    zio.aws.ec2.model.DescribeLocalGatewayRouteTableVpcAssociationsResponse
      .wrap(buildAwsValue())
}
object DescribeLocalGatewayRouteTableVpcAssociationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTableVpcAssociationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DescribeLocalGatewayRouteTableVpcAssociationsResponse =
      zio.aws.ec2.model.DescribeLocalGatewayRouteTableVpcAssociationsResponse(
        localGatewayRouteTableVpcAssociations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def localGatewayRouteTableVpcAssociations: Optional[
      List[zio.aws.ec2.model.LocalGatewayRouteTableVpcAssociation.ReadOnly]
    ]
    def nextToken: Optional[String]
    def getLocalGatewayRouteTableVpcAssociations: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.LocalGatewayRouteTableVpcAssociation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "localGatewayRouteTableVpcAssociations",
      localGatewayRouteTableVpcAssociations
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTableVpcAssociationsResponse
  ) extends zio.aws.ec2.model.DescribeLocalGatewayRouteTableVpcAssociationsResponse.ReadOnly {
    override val localGatewayRouteTableVpcAssociations: Optional[
      List[zio.aws.ec2.model.LocalGatewayRouteTableVpcAssociation.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.localGatewayRouteTableVpcAssociations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.LocalGatewayRouteTableVpcAssociation.wrap(item)
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayRouteTableVpcAssociationsResponse
  ): zio.aws.ec2.model.DescribeLocalGatewayRouteTableVpcAssociationsResponse.ReadOnly =
    new Wrapper(impl)
}
