package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeIdFormatResponse(
    statuses: Optional[Iterable[zio.aws.ec2.model.IdFormat]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeIdFormatResponse = {
    import DescribeIdFormatResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeIdFormatResponse
      .builder()
      .optionallyWith(
        statuses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.statuses)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeIdFormatResponse.ReadOnly =
    zio.aws.ec2.model.DescribeIdFormatResponse.wrap(buildAwsValue())
}
object DescribeIdFormatResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeIdFormatResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeIdFormatResponse =
      zio.aws.ec2.model.DescribeIdFormatResponse(
        statuses.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def statuses: Optional[List[zio.aws.ec2.model.IdFormat.ReadOnly]]
    def getStatuses
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.IdFormat.ReadOnly]] =
      AwsError.unwrapOptionField("statuses", statuses)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeIdFormatResponse
  ) extends zio.aws.ec2.model.DescribeIdFormatResponse.ReadOnly {
    override val statuses: Optional[List[zio.aws.ec2.model.IdFormat.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statuses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.IdFormat.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeIdFormatResponse
  ): zio.aws.ec2.model.DescribeIdFormatResponse.ReadOnly = new Wrapper(impl)
}
