package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeFastLaunchImagesResponse(
    fastLaunchImages: Optional[
      Iterable[zio.aws.ec2.model.DescribeFastLaunchImagesSuccessItem]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeFastLaunchImagesResponse = {
    import DescribeFastLaunchImagesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeFastLaunchImagesResponse
      .builder()
      .optionallyWith(
        fastLaunchImages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fastLaunchImages)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeFastLaunchImagesResponse.ReadOnly =
    zio.aws.ec2.model.DescribeFastLaunchImagesResponse.wrap(buildAwsValue())
}
object DescribeFastLaunchImagesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeFastLaunchImagesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeFastLaunchImagesResponse =
      zio.aws.ec2.model.DescribeFastLaunchImagesResponse(
        fastLaunchImages.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def fastLaunchImages: Optional[
      List[zio.aws.ec2.model.DescribeFastLaunchImagesSuccessItem.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getFastLaunchImages: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.DescribeFastLaunchImagesSuccessItem.ReadOnly
    ]] = AwsError.unwrapOptionField("fastLaunchImages", fastLaunchImages)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeFastLaunchImagesResponse
  ) extends zio.aws.ec2.model.DescribeFastLaunchImagesResponse.ReadOnly {
    override val fastLaunchImages: Optional[
      List[zio.aws.ec2.model.DescribeFastLaunchImagesSuccessItem.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.fastLaunchImages())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.DescribeFastLaunchImagesSuccessItem.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeFastLaunchImagesResponse
  ): zio.aws.ec2.model.DescribeFastLaunchImagesResponse.ReadOnly = new Wrapper(
    impl
  )
}
