package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeCoipPoolsResponse(
    coipPools: Optional[Iterable[zio.aws.ec2.model.CoipPool]] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeCoipPoolsResponse = {
    import DescribeCoipPoolsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeCoipPoolsResponse
      .builder()
      .optionallyWith(
        coipPools.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.coipPools)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeCoipPoolsResponse.ReadOnly =
    zio.aws.ec2.model.DescribeCoipPoolsResponse.wrap(buildAwsValue())
}
object DescribeCoipPoolsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeCoipPoolsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeCoipPoolsResponse =
      zio.aws.ec2.model.DescribeCoipPoolsResponse(
        coipPools.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def coipPools: Optional[List[zio.aws.ec2.model.CoipPool.ReadOnly]]
    def nextToken: Optional[String]
    def getCoipPools
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.CoipPool.ReadOnly]] =
      AwsError.unwrapOptionField("coipPools", coipPools)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeCoipPoolsResponse
  ) extends zio.aws.ec2.model.DescribeCoipPoolsResponse.ReadOnly {
    override val coipPools
        : Optional[List[zio.aws.ec2.model.CoipPool.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.coipPools())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.CoipPool.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeCoipPoolsResponse
  ): zio.aws.ec2.model.DescribeCoipPoolsResponse.ReadOnly = new Wrapper(impl)
}
