package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreditSpecification(
    cpuCredits: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreditSpecification = {
    import CreditSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreditSpecification
      .builder()
      .optionallyWith(cpuCredits.map(value => value: java.lang.String))(
        _.cpuCredits
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreditSpecification.ReadOnly =
    zio.aws.ec2.model.CreditSpecification.wrap(buildAwsValue())
}
object CreditSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreditSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreditSpecification =
      zio.aws.ec2.model.CreditSpecification(cpuCredits.map(value => value))
    def cpuCredits: Optional[String]
    def getCpuCredits: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cpuCredits", cpuCredits)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreditSpecification
  ) extends zio.aws.ec2.model.CreditSpecification.ReadOnly {
    override val cpuCredits: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cpuCredits())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreditSpecification
  ): zio.aws.ec2.model.CreditSpecification.ReadOnly = new Wrapper(impl)
}
