package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait ConnectivityType {
  def unwrap: software.amazon.awssdk.services.ec2.model.ConnectivityType
}
object ConnectivityType {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.ConnectivityType
  ): zio.aws.ec2.model.ConnectivityType = value match {
    case software.amazon.awssdk.services.ec2.model.ConnectivityType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.ConnectivityType.PRIVATE =>
      val r = `private`
      r
    case software.amazon.awssdk.services.ec2.model.ConnectivityType.PUBLIC =>
      val r = public
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.ConnectivityType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ConnectivityType =
      software.amazon.awssdk.services.ec2.model.ConnectivityType.UNKNOWN_TO_SDK_VERSION
  }
  case object `private` extends zio.aws.ec2.model.ConnectivityType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ConnectivityType =
      software.amazon.awssdk.services.ec2.model.ConnectivityType.PRIVATE
  }
  case object public extends zio.aws.ec2.model.ConnectivityType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ConnectivityType =
      software.amazon.awssdk.services.ec2.model.ConnectivityType.PUBLIC
  }
}
