package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{VpcId, SecurityGroupId, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ClientVpnEndpoint(
    clientVpnEndpointId: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    status: Optional[zio.aws.ec2.model.ClientVpnEndpointStatus] =
      Optional.Absent,
    creationTime: Optional[String] = Optional.Absent,
    deletionTime: Optional[String] = Optional.Absent,
    dnsName: Optional[String] = Optional.Absent,
    clientCidrBlock: Optional[String] = Optional.Absent,
    dnsServers: Optional[Iterable[String]] = Optional.Absent,
    splitTunnel: Optional[Boolean] = Optional.Absent,
    vpnProtocol: Optional[zio.aws.ec2.model.VpnProtocol] = Optional.Absent,
    transportProtocol: Optional[zio.aws.ec2.model.TransportProtocol] =
      Optional.Absent,
    vpnPort: Optional[Integer] = Optional.Absent,
    associatedTargetNetworks: Optional[
      Iterable[zio.aws.ec2.model.AssociatedTargetNetwork]
    ] = Optional.Absent,
    serverCertificateArn: Optional[String] = Optional.Absent,
    authenticationOptions: Optional[
      Iterable[zio.aws.ec2.model.ClientVpnAuthentication]
    ] = Optional.Absent,
    connectionLogOptions: Optional[
      zio.aws.ec2.model.ConnectionLogResponseOptions
    ] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent,
    securityGroupIds: Optional[Iterable[SecurityGroupId]] = Optional.Absent,
    vpcId: Optional[VpcId] = Optional.Absent,
    selfServicePortalUrl: Optional[String] = Optional.Absent,
    clientConnectOptions: Optional[
      zio.aws.ec2.model.ClientConnectResponseOptions
    ] = Optional.Absent,
    sessionTimeoutHours: Optional[Integer] = Optional.Absent,
    clientLoginBannerOptions: Optional[
      zio.aws.ec2.model.ClientLoginBannerResponseOptions
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ClientVpnEndpoint = {
    import ClientVpnEndpoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ClientVpnEndpoint
      .builder()
      .optionallyWith(
        clientVpnEndpointId.map(value => value: java.lang.String)
      )(_.clientVpnEndpointId)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .optionallyWith(creationTime.map(value => value: java.lang.String))(
        _.creationTime
      )
      .optionallyWith(deletionTime.map(value => value: java.lang.String))(
        _.deletionTime
      )
      .optionallyWith(dnsName.map(value => value: java.lang.String))(_.dnsName)
      .optionallyWith(clientCidrBlock.map(value => value: java.lang.String))(
        _.clientCidrBlock
      )
      .optionallyWith(
        dnsServers.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.dnsServers)
      .optionallyWith(splitTunnel.map(value => value: java.lang.Boolean))(
        _.splitTunnel
      )
      .optionallyWith(vpnProtocol.map(value => value.unwrap))(_.vpnProtocol)
      .optionallyWith(transportProtocol.map(value => value.unwrap))(
        _.transportProtocol
      )
      .optionallyWith(vpnPort.map(value => value: java.lang.Integer))(_.vpnPort)
      .optionallyWith(
        associatedTargetNetworks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.associatedTargetNetworks)
      .optionallyWith(
        serverCertificateArn.map(value => value: java.lang.String)
      )(_.serverCertificateArn)
      .optionallyWith(
        authenticationOptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.authenticationOptions)
      .optionallyWith(connectionLogOptions.map(value => value.buildAwsValue()))(
        _.connectionLogOptions
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(
        vpcId.map(value => VpcId.unwrap(value): java.lang.String)
      )(_.vpcId)
      .optionallyWith(
        selfServicePortalUrl.map(value => value: java.lang.String)
      )(_.selfServicePortalUrl)
      .optionallyWith(clientConnectOptions.map(value => value.buildAwsValue()))(
        _.clientConnectOptions
      )
      .optionallyWith(
        sessionTimeoutHours.map(value => value: java.lang.Integer)
      )(_.sessionTimeoutHours)
      .optionallyWith(
        clientLoginBannerOptions.map(value => value.buildAwsValue())
      )(_.clientLoginBannerOptions)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ClientVpnEndpoint.ReadOnly =
    zio.aws.ec2.model.ClientVpnEndpoint.wrap(buildAwsValue())
}
object ClientVpnEndpoint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ClientVpnEndpoint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ClientVpnEndpoint =
      zio.aws.ec2.model.ClientVpnEndpoint(
        clientVpnEndpointId.map(value => value),
        description.map(value => value),
        status.map(value => value.asEditable),
        creationTime.map(value => value),
        deletionTime.map(value => value),
        dnsName.map(value => value),
        clientCidrBlock.map(value => value),
        dnsServers.map(value => value),
        splitTunnel.map(value => value),
        vpnProtocol.map(value => value),
        transportProtocol.map(value => value),
        vpnPort.map(value => value),
        associatedTargetNetworks.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        serverCertificateArn.map(value => value),
        authenticationOptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        connectionLogOptions.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        securityGroupIds.map(value => value),
        vpcId.map(value => value),
        selfServicePortalUrl.map(value => value),
        clientConnectOptions.map(value => value.asEditable),
        sessionTimeoutHours.map(value => value),
        clientLoginBannerOptions.map(value => value.asEditable)
      )
    def clientVpnEndpointId: Optional[String]
    def description: Optional[String]
    def status: Optional[zio.aws.ec2.model.ClientVpnEndpointStatus.ReadOnly]
    def creationTime: Optional[String]
    def deletionTime: Optional[String]
    def dnsName: Optional[String]
    def clientCidrBlock: Optional[String]
    def dnsServers: Optional[List[String]]
    def splitTunnel: Optional[Boolean]
    def vpnProtocol: Optional[zio.aws.ec2.model.VpnProtocol]
    def transportProtocol: Optional[zio.aws.ec2.model.TransportProtocol]
    def vpnPort: Optional[Integer]
    def associatedTargetNetworks
        : Optional[List[zio.aws.ec2.model.AssociatedTargetNetwork.ReadOnly]]
    def serverCertificateArn: Optional[String]
    def authenticationOptions
        : Optional[List[zio.aws.ec2.model.ClientVpnAuthentication.ReadOnly]]
    def connectionLogOptions
        : Optional[zio.aws.ec2.model.ConnectionLogResponseOptions.ReadOnly]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def securityGroupIds: Optional[List[SecurityGroupId]]
    def vpcId: Optional[VpcId]
    def selfServicePortalUrl: Optional[String]
    def clientConnectOptions
        : Optional[zio.aws.ec2.model.ClientConnectResponseOptions.ReadOnly]
    def sessionTimeoutHours: Optional[Integer]
    def clientLoginBannerOptions
        : Optional[zio.aws.ec2.model.ClientLoginBannerResponseOptions.ReadOnly]
    def getClientVpnEndpointId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientVpnEndpointId", clientVpnEndpointId)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.ClientVpnEndpointStatus.ReadOnly
    ] = AwsError.unwrapOptionField("status", status)
    def getCreationTime: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getDeletionTime: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("deletionTime", deletionTime)
    def getDnsName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dnsName", dnsName)
    def getClientCidrBlock: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientCidrBlock", clientCidrBlock)
    def getDnsServers: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("dnsServers", dnsServers)
    def getSplitTunnel: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("splitTunnel", splitTunnel)
    def getVpnProtocol: ZIO[Any, AwsError, zio.aws.ec2.model.VpnProtocol] =
      AwsError.unwrapOptionField("vpnProtocol", vpnProtocol)
    def getTransportProtocol
        : ZIO[Any, AwsError, zio.aws.ec2.model.TransportProtocol] =
      AwsError.unwrapOptionField("transportProtocol", transportProtocol)
    def getVpnPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("vpnPort", vpnPort)
    def getAssociatedTargetNetworks: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.AssociatedTargetNetwork.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "associatedTargetNetworks",
      associatedTargetNetworks
    )
    def getServerCertificateArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serverCertificateArn", serverCertificateArn)
    def getAuthenticationOptions: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.ClientVpnAuthentication.ReadOnly
    ]] =
      AwsError.unwrapOptionField("authenticationOptions", authenticationOptions)
    def getConnectionLogOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.ConnectionLogResponseOptions.ReadOnly
    ] = AwsError.unwrapOptionField("connectionLogOptions", connectionLogOptions)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getVpcId: ZIO[Any, AwsError, VpcId] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getSelfServicePortalUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("selfServicePortalUrl", selfServicePortalUrl)
    def getClientConnectOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.ClientConnectResponseOptions.ReadOnly
    ] = AwsError.unwrapOptionField("clientConnectOptions", clientConnectOptions)
    def getSessionTimeoutHours: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("sessionTimeoutHours", sessionTimeoutHours)
    def getClientLoginBannerOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.ClientLoginBannerResponseOptions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "clientLoginBannerOptions",
      clientLoginBannerOptions
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ClientVpnEndpoint
  ) extends zio.aws.ec2.model.ClientVpnEndpoint.ReadOnly {
    override val clientVpnEndpointId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientVpnEndpointId())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val status
        : Optional[zio.aws.ec2.model.ClientVpnEndpointStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.ec2.model.ClientVpnEndpointStatus.wrap(value))
    override val creationTime: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => value: String)
    override val deletionTime: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.deletionTime())
      .map(value => value: String)
    override val dnsName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dnsName())
      .map(value => value: String)
    override val clientCidrBlock: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientCidrBlock())
      .map(value => value: String)
    override val dnsServers: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.dnsServers())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val splitTunnel: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.splitTunnel())
      .map(value => value: Boolean)
    override val vpnProtocol: Optional[zio.aws.ec2.model.VpnProtocol] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpnProtocol())
        .map(value => zio.aws.ec2.model.VpnProtocol.wrap(value))
    override val transportProtocol
        : Optional[zio.aws.ec2.model.TransportProtocol] = zio.aws.core.internal
      .optionalFromNullable(impl.transportProtocol())
      .map(value => zio.aws.ec2.model.TransportProtocol.wrap(value))
    override val vpnPort: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.vpnPort())
      .map(value => value: Integer)
    override val associatedTargetNetworks
        : Optional[List[zio.aws.ec2.model.AssociatedTargetNetwork.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associatedTargetNetworks())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.AssociatedTargetNetwork.wrap(item)
          }.toList
        )
    override val serverCertificateArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serverCertificateArn())
      .map(value => value: String)
    override val authenticationOptions
        : Optional[List[zio.aws.ec2.model.ClientVpnAuthentication.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authenticationOptions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.ClientVpnAuthentication.wrap(item)
          }.toList
        )
    override val connectionLogOptions
        : Optional[zio.aws.ec2.model.ConnectionLogResponseOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectionLogOptions())
        .map(value =>
          zio.aws.ec2.model.ConnectionLogResponseOptions.wrap(value)
        )
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
    override val securityGroupIds: Optional[List[SecurityGroupId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.SecurityGroupId(item)
          }.toList
        )
    override val vpcId: Optional[VpcId] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => zio.aws.ec2.model.primitives.VpcId(value))
    override val selfServicePortalUrl: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.selfServicePortalUrl())
      .map(value => value: String)
    override val clientConnectOptions
        : Optional[zio.aws.ec2.model.ClientConnectResponseOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientConnectOptions())
        .map(value =>
          zio.aws.ec2.model.ClientConnectResponseOptions.wrap(value)
        )
    override val sessionTimeoutHours: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.sessionTimeoutHours())
      .map(value => value: Integer)
    override val clientLoginBannerOptions: Optional[
      zio.aws.ec2.model.ClientLoginBannerResponseOptions.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.clientLoginBannerOptions())
      .map(value =>
        zio.aws.ec2.model.ClientLoginBannerResponseOptions.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ClientVpnEndpoint
  ): zio.aws.ec2.model.ClientVpnEndpoint.ReadOnly = new Wrapper(impl)
}
