package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.CapacityReservationId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CancelCapacityReservationRequest(
    capacityReservationId: CapacityReservationId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CancelCapacityReservationRequest = {
    import CancelCapacityReservationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CancelCapacityReservationRequest
      .builder()
      .capacityReservationId(
        CapacityReservationId.unwrap(capacityReservationId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CancelCapacityReservationRequest.ReadOnly =
    zio.aws.ec2.model.CancelCapacityReservationRequest.wrap(buildAwsValue())
}
object CancelCapacityReservationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CancelCapacityReservationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CancelCapacityReservationRequest =
      zio.aws.ec2.model.CancelCapacityReservationRequest(capacityReservationId)
    def capacityReservationId: CapacityReservationId
    def getCapacityReservationId: ZIO[Any, Nothing, CapacityReservationId] =
      ZIO.succeed(capacityReservationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CancelCapacityReservationRequest
  ) extends zio.aws.ec2.model.CancelCapacityReservationRequest.ReadOnly {
    override val capacityReservationId: CapacityReservationId =
      zio.aws.ec2.model.primitives
        .CapacityReservationId(impl.capacityReservationId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CancelCapacityReservationRequest
  ): zio.aws.ec2.model.CancelCapacityReservationRequest.ReadOnly = new Wrapper(
    impl
  )
}
