package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AvailableCapacity(
    availableInstanceCapacity: Optional[
      Iterable[zio.aws.ec2.model.InstanceCapacity]
    ] = Optional.Absent,
    availableVCpus: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AvailableCapacity = {
    import AvailableCapacity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AvailableCapacity
      .builder()
      .optionallyWith(
        availableInstanceCapacity.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.availableInstanceCapacity)
      .optionallyWith(availableVCpus.map(value => value: java.lang.Integer))(
        _.availableVCpus
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AvailableCapacity.ReadOnly =
    zio.aws.ec2.model.AvailableCapacity.wrap(buildAwsValue())
}
object AvailableCapacity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AvailableCapacity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AvailableCapacity =
      zio.aws.ec2.model.AvailableCapacity(
        availableInstanceCapacity.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        availableVCpus.map(value => value)
      )
    def availableInstanceCapacity
        : Optional[List[zio.aws.ec2.model.InstanceCapacity.ReadOnly]]
    def availableVCpus: Optional[Integer]
    def getAvailableInstanceCapacity: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.InstanceCapacity.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "availableInstanceCapacity",
      availableInstanceCapacity
    )
    def getAvailableVCpus: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("availableVCpus", availableVCpus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AvailableCapacity
  ) extends zio.aws.ec2.model.AvailableCapacity.ReadOnly {
    override val availableInstanceCapacity
        : Optional[List[zio.aws.ec2.model.InstanceCapacity.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availableInstanceCapacity())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.InstanceCapacity.wrap(item)
          }.toList
        )
    override val availableVCpus: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.availableVCpus())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AvailableCapacity
  ): zio.aws.ec2.model.AvailableCapacity.ReadOnly = new Wrapper(impl)
}
