package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  SubnetId,
  TransitGatewayAttachmentId,
  TransitGatewayMulticastDomainId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AssociateTransitGatewayMulticastDomainRequest(
    transitGatewayMulticastDomainId: Optional[TransitGatewayMulticastDomainId] =
      Optional.Absent,
    transitGatewayAttachmentId: Optional[TransitGatewayAttachmentId] =
      Optional.Absent,
    subnetIds: Optional[Iterable[SubnetId]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AssociateTransitGatewayMulticastDomainRequest = {
    import AssociateTransitGatewayMulticastDomainRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AssociateTransitGatewayMulticastDomainRequest
      .builder()
      .optionallyWith(
        transitGatewayMulticastDomainId.map(value =>
          TransitGatewayMulticastDomainId.unwrap(value): java.lang.String
        )
      )(_.transitGatewayMulticastDomainId)
      .optionallyWith(
        transitGatewayAttachmentId.map(value =>
          TransitGatewayAttachmentId.unwrap(value): java.lang.String
        )
      )(_.transitGatewayAttachmentId)
      .optionallyWith(
        subnetIds.map(value =>
          value.map { item =>
            SubnetId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.subnetIds)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.AssociateTransitGatewayMulticastDomainRequest.ReadOnly =
    zio.aws.ec2.model.AssociateTransitGatewayMulticastDomainRequest
      .wrap(buildAwsValue())
}
object AssociateTransitGatewayMulticastDomainRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AssociateTransitGatewayMulticastDomainRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.AssociateTransitGatewayMulticastDomainRequest =
      zio.aws.ec2.model.AssociateTransitGatewayMulticastDomainRequest(
        transitGatewayMulticastDomainId.map(value => value),
        transitGatewayAttachmentId.map(value => value),
        subnetIds.map(value => value)
      )
    def transitGatewayMulticastDomainId
        : Optional[TransitGatewayMulticastDomainId]
    def transitGatewayAttachmentId: Optional[TransitGatewayAttachmentId]
    def subnetIds: Optional[List[SubnetId]]
    def getTransitGatewayMulticastDomainId
        : ZIO[Any, AwsError, TransitGatewayMulticastDomainId] =
      AwsError.unwrapOptionField(
        "transitGatewayMulticastDomainId",
        transitGatewayMulticastDomainId
      )
    def getTransitGatewayAttachmentId
        : ZIO[Any, AwsError, TransitGatewayAttachmentId] =
      AwsError.unwrapOptionField(
        "transitGatewayAttachmentId",
        transitGatewayAttachmentId
      )
    def getSubnetIds: ZIO[Any, AwsError, List[SubnetId]] =
      AwsError.unwrapOptionField("subnetIds", subnetIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AssociateTransitGatewayMulticastDomainRequest
  ) extends zio.aws.ec2.model.AssociateTransitGatewayMulticastDomainRequest.ReadOnly {
    override val transitGatewayMulticastDomainId
        : Optional[TransitGatewayMulticastDomainId] = zio.aws.core.internal
      .optionalFromNullable(impl.transitGatewayMulticastDomainId())
      .map(value =>
        zio.aws.ec2.model.primitives.TransitGatewayMulticastDomainId(value)
      )
    override val transitGatewayAttachmentId
        : Optional[TransitGatewayAttachmentId] = zio.aws.core.internal
      .optionalFromNullable(impl.transitGatewayAttachmentId())
      .map(value =>
        zio.aws.ec2.model.primitives.TransitGatewayAttachmentId(value)
      )
    override val subnetIds: Optional[List[SubnetId]] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.SubnetId(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AssociateTransitGatewayMulticastDomainRequest
  ): zio.aws.ec2.model.AssociateTransitGatewayMulticastDomainRequest.ReadOnly =
    new Wrapper(impl)
}
