package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait VolumeStatusInfoStatus {
  def unwrap: software.amazon.awssdk.services.ec2.model.VolumeStatusInfoStatus
}
object VolumeStatusInfoStatus {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.VolumeStatusInfoStatus
  ): zio.aws.ec2.model.VolumeStatusInfoStatus = value match {
    case software.amazon.awssdk.services.ec2.model.VolumeStatusInfoStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.VolumeStatusInfoStatus.OK =>
      val r = ok
      r
    case software.amazon.awssdk.services.ec2.model.VolumeStatusInfoStatus.IMPAIRED =>
      val r = impaired
      r
    case software.amazon.awssdk.services.ec2.model.VolumeStatusInfoStatus.INSUFFICIENT_DATA =>
      val r = `insufficient-data`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.VolumeStatusInfoStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.VolumeStatusInfoStatus =
      software.amazon.awssdk.services.ec2.model.VolumeStatusInfoStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ok extends zio.aws.ec2.model.VolumeStatusInfoStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.VolumeStatusInfoStatus =
      software.amazon.awssdk.services.ec2.model.VolumeStatusInfoStatus.OK
  }
  case object impaired extends zio.aws.ec2.model.VolumeStatusInfoStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.VolumeStatusInfoStatus =
      software.amazon.awssdk.services.ec2.model.VolumeStatusInfoStatus.IMPAIRED
  }
  case object `insufficient-data`
      extends zio.aws.ec2.model.VolumeStatusInfoStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.VolumeStatusInfoStatus =
      software.amazon.awssdk.services.ec2.model.VolumeStatusInfoStatus.INSUFFICIENT_DATA
  }
}
