package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.DateTime
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class TransitGatewayRouteTable(
    transitGatewayRouteTableId: Option[String] = None,
    transitGatewayId: Option[String] = None,
    state: Option[zio.aws.ec2.model.TransitGatewayRouteTableState] = None,
    defaultAssociationRouteTable: Option[Boolean] = None,
    defaultPropagationRouteTable: Option[Boolean] = None,
    creationTime: Option[DateTime] = None,
    tags: Option[Iterable[zio.aws.ec2.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TransitGatewayRouteTable = {
    import TransitGatewayRouteTable.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TransitGatewayRouteTable
      .builder()
      .optionallyWith(
        transitGatewayRouteTableId.map(value => value: java.lang.String)
      )(_.transitGatewayRouteTableId)
      .optionallyWith(transitGatewayId.map(value => value: java.lang.String))(
        _.transitGatewayId
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        defaultAssociationRouteTable.map(value => value: java.lang.Boolean)
      )(_.defaultAssociationRouteTable)
      .optionallyWith(
        defaultPropagationRouteTable.map(value => value: java.lang.Boolean)
      )(_.defaultPropagationRouteTable)
      .optionallyWith(
        creationTime.map(value => DateTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.TransitGatewayRouteTable.ReadOnly =
    zio.aws.ec2.model.TransitGatewayRouteTable.wrap(buildAwsValue())
}
object TransitGatewayRouteTable {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TransitGatewayRouteTable
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TransitGatewayRouteTable =
      zio.aws.ec2.model.TransitGatewayRouteTable(
        transitGatewayRouteTableId.map(value => value),
        transitGatewayId.map(value => value),
        state.map(value => value),
        defaultAssociationRouteTable.map(value => value),
        defaultPropagationRouteTable.map(value => value),
        creationTime.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def transitGatewayRouteTableId: Option[String]
    def transitGatewayId: Option[String]
    def state: Option[zio.aws.ec2.model.TransitGatewayRouteTableState]
    def defaultAssociationRouteTable: Option[Boolean]
    def defaultPropagationRouteTable: Option[Boolean]
    def creationTime: Option[DateTime]
    def tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getTransitGatewayRouteTableId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "transitGatewayRouteTableId",
        transitGatewayRouteTableId
      )
    def getTransitGatewayId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("transitGatewayId", transitGatewayId)
    def getState
        : ZIO[Any, AwsError, zio.aws.ec2.model.TransitGatewayRouteTableState] =
      AwsError.unwrapOptionField("state", state)
    def getDefaultAssociationRouteTable: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "defaultAssociationRouteTable",
        defaultAssociationRouteTable
      )
    def getDefaultPropagationRouteTable: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "defaultPropagationRouteTable",
        defaultPropagationRouteTable
      )
    def getCreationTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayRouteTable
  ) extends zio.aws.ec2.model.TransitGatewayRouteTable.ReadOnly {
    override val transitGatewayRouteTableId: Option[String] = scala
      .Option(impl.transitGatewayRouteTableId())
      .map(value => value: String)
    override val transitGatewayId: Option[String] =
      scala.Option(impl.transitGatewayId()).map(value => value: String)
    override val state
        : Option[zio.aws.ec2.model.TransitGatewayRouteTableState] = scala
      .Option(impl.state())
      .map(value => zio.aws.ec2.model.TransitGatewayRouteTableState.wrap(value))
    override val defaultAssociationRouteTable: Option[Boolean] = scala
      .Option(impl.defaultAssociationRouteTable())
      .map(value => value: Boolean)
    override val defaultPropagationRouteTable: Option[Boolean] = scala
      .Option(impl.defaultPropagationRouteTable())
      .map(value => value: Boolean)
    override val creationTime: Option[DateTime] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayRouteTable
  ): zio.aws.ec2.model.TransitGatewayRouteTable.ReadOnly = new Wrapper(impl)
}
