package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.DateTime
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class TransitGatewayPeeringAttachment(
    transitGatewayAttachmentId: Option[String] = None,
    requesterTgwInfo: Option[zio.aws.ec2.model.PeeringTgwInfo] = None,
    accepterTgwInfo: Option[zio.aws.ec2.model.PeeringTgwInfo] = None,
    status: Option[zio.aws.ec2.model.PeeringAttachmentStatus] = None,
    state: Option[zio.aws.ec2.model.TransitGatewayAttachmentState] = None,
    creationTime: Option[DateTime] = None,
    tags: Option[Iterable[zio.aws.ec2.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TransitGatewayPeeringAttachment = {
    import TransitGatewayPeeringAttachment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TransitGatewayPeeringAttachment
      .builder()
      .optionallyWith(
        transitGatewayAttachmentId.map(value => value: java.lang.String)
      )(_.transitGatewayAttachmentId)
      .optionallyWith(requesterTgwInfo.map(value => value.buildAwsValue()))(
        _.requesterTgwInfo
      )
      .optionallyWith(accepterTgwInfo.map(value => value.buildAwsValue()))(
        _.accepterTgwInfo
      )
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        creationTime.map(value => DateTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.TransitGatewayPeeringAttachment.ReadOnly =
    zio.aws.ec2.model.TransitGatewayPeeringAttachment.wrap(buildAwsValue())
}
object TransitGatewayPeeringAttachment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TransitGatewayPeeringAttachment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TransitGatewayPeeringAttachment =
      zio.aws.ec2.model.TransitGatewayPeeringAttachment(
        transitGatewayAttachmentId.map(value => value),
        requesterTgwInfo.map(value => value.asEditable),
        accepterTgwInfo.map(value => value.asEditable),
        status.map(value => value.asEditable),
        state.map(value => value),
        creationTime.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def transitGatewayAttachmentId: Option[String]
    def requesterTgwInfo: Option[zio.aws.ec2.model.PeeringTgwInfo.ReadOnly]
    def accepterTgwInfo: Option[zio.aws.ec2.model.PeeringTgwInfo.ReadOnly]
    def status: Option[zio.aws.ec2.model.PeeringAttachmentStatus.ReadOnly]
    def state: Option[zio.aws.ec2.model.TransitGatewayAttachmentState]
    def creationTime: Option[DateTime]
    def tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getTransitGatewayAttachmentId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "transitGatewayAttachmentId",
        transitGatewayAttachmentId
      )
    def getRequesterTgwInfo
        : ZIO[Any, AwsError, zio.aws.ec2.model.PeeringTgwInfo.ReadOnly] =
      AwsError.unwrapOptionField("requesterTgwInfo", requesterTgwInfo)
    def getAccepterTgwInfo
        : ZIO[Any, AwsError, zio.aws.ec2.model.PeeringTgwInfo.ReadOnly] =
      AwsError.unwrapOptionField("accepterTgwInfo", accepterTgwInfo)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.PeeringAttachmentStatus.ReadOnly
    ] = AwsError.unwrapOptionField("status", status)
    def getState
        : ZIO[Any, AwsError, zio.aws.ec2.model.TransitGatewayAttachmentState] =
      AwsError.unwrapOptionField("state", state)
    def getCreationTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayPeeringAttachment
  ) extends zio.aws.ec2.model.TransitGatewayPeeringAttachment.ReadOnly {
    override val transitGatewayAttachmentId: Option[String] = scala
      .Option(impl.transitGatewayAttachmentId())
      .map(value => value: String)
    override val requesterTgwInfo
        : Option[zio.aws.ec2.model.PeeringTgwInfo.ReadOnly] = scala
      .Option(impl.requesterTgwInfo())
      .map(value => zio.aws.ec2.model.PeeringTgwInfo.wrap(value))
    override val accepterTgwInfo
        : Option[zio.aws.ec2.model.PeeringTgwInfo.ReadOnly] = scala
      .Option(impl.accepterTgwInfo())
      .map(value => zio.aws.ec2.model.PeeringTgwInfo.wrap(value))
    override val status
        : Option[zio.aws.ec2.model.PeeringAttachmentStatus.ReadOnly] = scala
      .Option(impl.status())
      .map(value => zio.aws.ec2.model.PeeringAttachmentStatus.wrap(value))
    override val state
        : Option[zio.aws.ec2.model.TransitGatewayAttachmentState] = scala
      .Option(impl.state())
      .map(value => zio.aws.ec2.model.TransitGatewayAttachmentState.wrap(value))
    override val creationTime: Option[DateTime] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayPeeringAttachment
  ): zio.aws.ec2.model.TransitGatewayPeeringAttachment.ReadOnly = new Wrapper(
    impl
  )
}
