package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.DateTime
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class TransitGatewayMulticastDomain(
    transitGatewayMulticastDomainId: Option[String] = None,
    transitGatewayId: Option[String] = None,
    transitGatewayMulticastDomainArn: Option[String] = None,
    ownerId: Option[String] = None,
    options: Option[zio.aws.ec2.model.TransitGatewayMulticastDomainOptions] =
      None,
    state: Option[zio.aws.ec2.model.TransitGatewayMulticastDomainState] = None,
    creationTime: Option[DateTime] = None,
    tags: Option[Iterable[zio.aws.ec2.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastDomain = {
    import TransitGatewayMulticastDomain.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastDomain
      .builder()
      .optionallyWith(
        transitGatewayMulticastDomainId.map(value => value: java.lang.String)
      )(_.transitGatewayMulticastDomainId)
      .optionallyWith(transitGatewayId.map(value => value: java.lang.String))(
        _.transitGatewayId
      )
      .optionallyWith(
        transitGatewayMulticastDomainArn.map(value => value: java.lang.String)
      )(_.transitGatewayMulticastDomainArn)
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .optionallyWith(options.map(value => value.buildAwsValue()))(_.options)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        creationTime.map(value => DateTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.TransitGatewayMulticastDomain.ReadOnly =
    zio.aws.ec2.model.TransitGatewayMulticastDomain.wrap(buildAwsValue())
}
object TransitGatewayMulticastDomain {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastDomain
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TransitGatewayMulticastDomain =
      zio.aws.ec2.model.TransitGatewayMulticastDomain(
        transitGatewayMulticastDomainId.map(value => value),
        transitGatewayId.map(value => value),
        transitGatewayMulticastDomainArn.map(value => value),
        ownerId.map(value => value),
        options.map(value => value.asEditable),
        state.map(value => value),
        creationTime.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def transitGatewayMulticastDomainId: Option[String]
    def transitGatewayId: Option[String]
    def transitGatewayMulticastDomainArn: Option[String]
    def ownerId: Option[String]
    def options: Option[
      zio.aws.ec2.model.TransitGatewayMulticastDomainOptions.ReadOnly
    ]
    def state: Option[zio.aws.ec2.model.TransitGatewayMulticastDomainState]
    def creationTime: Option[DateTime]
    def tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getTransitGatewayMulticastDomainId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "transitGatewayMulticastDomainId",
        transitGatewayMulticastDomainId
      )
    def getTransitGatewayId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("transitGatewayId", transitGatewayId)
    def getTransitGatewayMulticastDomainArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "transitGatewayMulticastDomainArn",
        transitGatewayMulticastDomainArn
      )
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayMulticastDomainOptions.ReadOnly
    ] = AwsError.unwrapOptionField("options", options)
    def getState: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayMulticastDomainState
    ] = AwsError.unwrapOptionField("state", state)
    def getCreationTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastDomain
  ) extends zio.aws.ec2.model.TransitGatewayMulticastDomain.ReadOnly {
    override val transitGatewayMulticastDomainId: Option[String] = scala
      .Option(impl.transitGatewayMulticastDomainId())
      .map(value => value: String)
    override val transitGatewayId: Option[String] =
      scala.Option(impl.transitGatewayId()).map(value => value: String)
    override val transitGatewayMulticastDomainArn: Option[String] = scala
      .Option(impl.transitGatewayMulticastDomainArn())
      .map(value => value: String)
    override val ownerId: Option[String] =
      scala.Option(impl.ownerId()).map(value => value: String)
    override val options: Option[
      zio.aws.ec2.model.TransitGatewayMulticastDomainOptions.ReadOnly
    ] = scala
      .Option(impl.options())
      .map(value =>
        zio.aws.ec2.model.TransitGatewayMulticastDomainOptions.wrap(value)
      )
    override val state
        : Option[zio.aws.ec2.model.TransitGatewayMulticastDomainState] = scala
      .Option(impl.state())
      .map(value =>
        zio.aws.ec2.model.TransitGatewayMulticastDomainState.wrap(value)
      )
    override val creationTime: Option[DateTime] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastDomain
  ): zio.aws.ec2.model.TransitGatewayMulticastDomain.ReadOnly = new Wrapper(
    impl
  )
}
