package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TransitGatewayMulticastDeregisteredGroupMembers(
    transitGatewayMulticastDomainId: Option[String] = None,
    deregisteredNetworkInterfaceIds: Option[Iterable[String]] = None,
    groupIpAddress: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastDeregisteredGroupMembers = {
    import TransitGatewayMulticastDeregisteredGroupMembers.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastDeregisteredGroupMembers
      .builder()
      .optionallyWith(
        transitGatewayMulticastDomainId.map(value => value: java.lang.String)
      )(_.transitGatewayMulticastDomainId)
      .optionallyWith(
        deregisteredNetworkInterfaceIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.deregisteredNetworkInterfaceIds)
      .optionallyWith(groupIpAddress.map(value => value: java.lang.String))(
        _.groupIpAddress
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.TransitGatewayMulticastDeregisteredGroupMembers.ReadOnly =
    zio.aws.ec2.model.TransitGatewayMulticastDeregisteredGroupMembers
      .wrap(buildAwsValue())
}
object TransitGatewayMulticastDeregisteredGroupMembers {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastDeregisteredGroupMembers
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.TransitGatewayMulticastDeregisteredGroupMembers =
      zio.aws.ec2.model.TransitGatewayMulticastDeregisteredGroupMembers(
        transitGatewayMulticastDomainId.map(value => value),
        deregisteredNetworkInterfaceIds.map(value => value),
        groupIpAddress.map(value => value)
      )
    def transitGatewayMulticastDomainId: Option[String]
    def deregisteredNetworkInterfaceIds: Option[List[String]]
    def groupIpAddress: Option[String]
    def getTransitGatewayMulticastDomainId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "transitGatewayMulticastDomainId",
        transitGatewayMulticastDomainId
      )
    def getDeregisteredNetworkInterfaceIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "deregisteredNetworkInterfaceIds",
        deregisteredNetworkInterfaceIds
      )
    def getGroupIpAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("groupIpAddress", groupIpAddress)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastDeregisteredGroupMembers
  ) extends zio.aws.ec2.model.TransitGatewayMulticastDeregisteredGroupMembers.ReadOnly {
    override val transitGatewayMulticastDomainId: Option[String] = scala
      .Option(impl.transitGatewayMulticastDomainId())
      .map(value => value: String)
    override val deregisteredNetworkInterfaceIds: Option[List[String]] = scala
      .Option(impl.deregisteredNetworkInterfaceIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val groupIpAddress: Option[String] =
      scala.Option(impl.groupIpAddress()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastDeregisteredGroupMembers
  ): zio.aws.ec2.model.TransitGatewayMulticastDeregisteredGroupMembers.ReadOnly =
    new Wrapper(impl)
}
