package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait RootDeviceType {
  def unwrap: software.amazon.awssdk.services.ec2.model.RootDeviceType
}
object RootDeviceType {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.RootDeviceType
  ): zio.aws.ec2.model.RootDeviceType = value match {
    case software.amazon.awssdk.services.ec2.model.RootDeviceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.RootDeviceType.EBS =>
      val r = ebs
      r
    case software.amazon.awssdk.services.ec2.model.RootDeviceType.INSTANCE_STORE =>
      val r = `instance-store`
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.RootDeviceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.RootDeviceType =
      software.amazon.awssdk.services.ec2.model.RootDeviceType.UNKNOWN_TO_SDK_VERSION
  }
  case object ebs extends zio.aws.ec2.model.RootDeviceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.RootDeviceType =
      software.amazon.awssdk.services.ec2.model.RootDeviceType.EBS
  }
  case object `instance-store` extends zio.aws.ec2.model.RootDeviceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.RootDeviceType =
      software.amazon.awssdk.services.ec2.model.RootDeviceType.INSTANCE_STORE
  }
}
