package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RevokeSecurityGroupIngressResponse(
    returnValue: Option[Boolean] = None,
    unknownIpPermissions: Option[Iterable[zio.aws.ec2.model.IpPermission]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.RevokeSecurityGroupIngressResponse = {
    import RevokeSecurityGroupIngressResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RevokeSecurityGroupIngressResponse
      .builder()
      .optionallyWith(returnValue.map(value => value: java.lang.Boolean))(
        _.returnValue
      )
      .optionallyWith(
        unknownIpPermissions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.unknownIpPermissions)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.RevokeSecurityGroupIngressResponse.ReadOnly =
    zio.aws.ec2.model.RevokeSecurityGroupIngressResponse.wrap(buildAwsValue())
}
object RevokeSecurityGroupIngressResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.RevokeSecurityGroupIngressResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.RevokeSecurityGroupIngressResponse =
      zio.aws.ec2.model.RevokeSecurityGroupIngressResponse(
        returnValue.map(value => value),
        unknownIpPermissions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def returnValue: Option[Boolean]
    def unknownIpPermissions
        : Option[List[zio.aws.ec2.model.IpPermission.ReadOnly]]
    def getReturnValue: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("returnValue", returnValue)
    def getUnknownIpPermissions
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.IpPermission.ReadOnly]] =
      AwsError.unwrapOptionField("unknownIpPermissions", unknownIpPermissions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RevokeSecurityGroupIngressResponse
  ) extends zio.aws.ec2.model.RevokeSecurityGroupIngressResponse.ReadOnly {
    override val returnValue: Option[Boolean] =
      scala.Option(impl.returnValue()).map(value => value: Boolean)
    override val unknownIpPermissions
        : Option[List[zio.aws.ec2.model.IpPermission.ReadOnly]] = scala
      .Option(impl.unknownIpPermissions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.IpPermission.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RevokeSecurityGroupIngressResponse
  ): zio.aws.ec2.model.RevokeSecurityGroupIngressResponse.ReadOnly =
    new Wrapper(impl)
}
