package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  KeyPairName,
  SecurityGroupId,
  KernelId,
  SecurityGroupName,
  ImageId,
  RamdiskId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RequestLaunchTemplateData(
    kernelId: Option[KernelId] = None,
    ebsOptimized: Option[Boolean] = None,
    iamInstanceProfile: Option[
      zio.aws.ec2.model.LaunchTemplateIamInstanceProfileSpecificationRequest
    ] = None,
    blockDeviceMappings: Option[
      Iterable[zio.aws.ec2.model.LaunchTemplateBlockDeviceMappingRequest]
    ] = None,
    networkInterfaces: Option[Iterable[
      zio.aws.ec2.model.LaunchTemplateInstanceNetworkInterfaceSpecificationRequest
    ]] = None,
    imageId: Option[ImageId] = None,
    instanceType: Option[zio.aws.ec2.model.InstanceType] = None,
    keyName: Option[KeyPairName] = None,
    monitoring: Option[zio.aws.ec2.model.LaunchTemplatesMonitoringRequest] =
      None,
    placement: Option[zio.aws.ec2.model.LaunchTemplatePlacementRequest] = None,
    ramDiskId: Option[RamdiskId] = None,
    disableApiTermination: Option[Boolean] = None,
    instanceInitiatedShutdownBehavior: Option[
      zio.aws.ec2.model.ShutdownBehavior
    ] = None,
    userData: Option[String] = None,
    tagSpecifications: Option[
      Iterable[zio.aws.ec2.model.LaunchTemplateTagSpecificationRequest]
    ] = None,
    elasticGpuSpecifications: Option[
      Iterable[zio.aws.ec2.model.ElasticGpuSpecification]
    ] = None,
    elasticInferenceAccelerators: Option[
      Iterable[zio.aws.ec2.model.LaunchTemplateElasticInferenceAccelerator]
    ] = None,
    securityGroupIds: Option[Iterable[SecurityGroupId]] = None,
    securityGroups: Option[Iterable[SecurityGroupName]] = None,
    instanceMarketOptions: Option[
      zio.aws.ec2.model.LaunchTemplateInstanceMarketOptionsRequest
    ] = None,
    creditSpecification: Option[zio.aws.ec2.model.CreditSpecificationRequest] =
      None,
    cpuOptions: Option[zio.aws.ec2.model.LaunchTemplateCpuOptionsRequest] =
      None,
    capacityReservationSpecification: Option[
      zio.aws.ec2.model.LaunchTemplateCapacityReservationSpecificationRequest
    ] = None,
    licenseSpecifications: Option[
      Iterable[zio.aws.ec2.model.LaunchTemplateLicenseConfigurationRequest]
    ] = None,
    hibernationOptions: Option[
      zio.aws.ec2.model.LaunchTemplateHibernationOptionsRequest
    ] = None,
    metadataOptions: Option[
      zio.aws.ec2.model.LaunchTemplateInstanceMetadataOptionsRequest
    ] = None,
    enclaveOptions: Option[
      zio.aws.ec2.model.LaunchTemplateEnclaveOptionsRequest
    ] = None,
    instanceRequirements: Option[
      zio.aws.ec2.model.InstanceRequirementsRequest
    ] = None,
    privateDnsNameOptions: Option[
      zio.aws.ec2.model.LaunchTemplatePrivateDnsNameOptionsRequest
    ] = None,
    maintenanceOptions: Option[
      zio.aws.ec2.model.LaunchTemplateInstanceMaintenanceOptionsRequest
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.RequestLaunchTemplateData = {
    import RequestLaunchTemplateData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RequestLaunchTemplateData
      .builder()
      .optionallyWith(
        kernelId.map(value => KernelId.unwrap(value): java.lang.String)
      )(_.kernelId)
      .optionallyWith(ebsOptimized.map(value => value: java.lang.Boolean))(
        _.ebsOptimized
      )
      .optionallyWith(iamInstanceProfile.map(value => value.buildAwsValue()))(
        _.iamInstanceProfile
      )
      .optionallyWith(
        blockDeviceMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.blockDeviceMappings)
      .optionallyWith(
        networkInterfaces.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkInterfaces)
      .optionallyWith(
        imageId.map(value => ImageId.unwrap(value): java.lang.String)
      )(_.imageId)
      .optionallyWith(instanceType.map(value => value.unwrap))(_.instanceType)
      .optionallyWith(
        keyName.map(value => KeyPairName.unwrap(value): java.lang.String)
      )(_.keyName)
      .optionallyWith(monitoring.map(value => value.buildAwsValue()))(
        _.monitoring
      )
      .optionallyWith(placement.map(value => value.buildAwsValue()))(
        _.placement
      )
      .optionallyWith(
        ramDiskId.map(value => RamdiskId.unwrap(value): java.lang.String)
      )(_.ramDiskId)
      .optionallyWith(
        disableApiTermination.map(value => value: java.lang.Boolean)
      )(_.disableApiTermination)
      .optionallyWith(
        instanceInitiatedShutdownBehavior.map(value => value.unwrap)
      )(_.instanceInitiatedShutdownBehavior)
      .optionallyWith(userData.map(value => value: java.lang.String))(
        _.userData
      )
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .optionallyWith(
        elasticGpuSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.elasticGpuSpecifications)
      .optionallyWith(
        elasticInferenceAccelerators.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.elasticInferenceAccelerators)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(
        securityGroups.map(value =>
          value.map { item =>
            SecurityGroupName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroups)
      .optionallyWith(
        instanceMarketOptions.map(value => value.buildAwsValue())
      )(_.instanceMarketOptions)
      .optionallyWith(creditSpecification.map(value => value.buildAwsValue()))(
        _.creditSpecification
      )
      .optionallyWith(cpuOptions.map(value => value.buildAwsValue()))(
        _.cpuOptions
      )
      .optionallyWith(
        capacityReservationSpecification.map(value => value.buildAwsValue())
      )(_.capacityReservationSpecification)
      .optionallyWith(
        licenseSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.licenseSpecifications)
      .optionallyWith(hibernationOptions.map(value => value.buildAwsValue()))(
        _.hibernationOptions
      )
      .optionallyWith(metadataOptions.map(value => value.buildAwsValue()))(
        _.metadataOptions
      )
      .optionallyWith(enclaveOptions.map(value => value.buildAwsValue()))(
        _.enclaveOptions
      )
      .optionallyWith(instanceRequirements.map(value => value.buildAwsValue()))(
        _.instanceRequirements
      )
      .optionallyWith(
        privateDnsNameOptions.map(value => value.buildAwsValue())
      )(_.privateDnsNameOptions)
      .optionallyWith(maintenanceOptions.map(value => value.buildAwsValue()))(
        _.maintenanceOptions
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.RequestLaunchTemplateData.ReadOnly =
    zio.aws.ec2.model.RequestLaunchTemplateData.wrap(buildAwsValue())
}
object RequestLaunchTemplateData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.RequestLaunchTemplateData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.RequestLaunchTemplateData =
      zio.aws.ec2.model.RequestLaunchTemplateData(
        kernelId.map(value => value),
        ebsOptimized.map(value => value),
        iamInstanceProfile.map(value => value.asEditable),
        blockDeviceMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        networkInterfaces.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        imageId.map(value => value),
        instanceType.map(value => value),
        keyName.map(value => value),
        monitoring.map(value => value.asEditable),
        placement.map(value => value.asEditable),
        ramDiskId.map(value => value),
        disableApiTermination.map(value => value),
        instanceInitiatedShutdownBehavior.map(value => value),
        userData.map(value => value),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        elasticGpuSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        elasticInferenceAccelerators.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        securityGroupIds.map(value => value),
        securityGroups.map(value => value),
        instanceMarketOptions.map(value => value.asEditable),
        creditSpecification.map(value => value.asEditable),
        cpuOptions.map(value => value.asEditable),
        capacityReservationSpecification.map(value => value.asEditable),
        licenseSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        hibernationOptions.map(value => value.asEditable),
        metadataOptions.map(value => value.asEditable),
        enclaveOptions.map(value => value.asEditable),
        instanceRequirements.map(value => value.asEditable),
        privateDnsNameOptions.map(value => value.asEditable),
        maintenanceOptions.map(value => value.asEditable)
      )
    def kernelId: Option[KernelId]
    def ebsOptimized: Option[Boolean]
    def iamInstanceProfile: Option[
      zio.aws.ec2.model.LaunchTemplateIamInstanceProfileSpecificationRequest.ReadOnly
    ]
    def blockDeviceMappings: Option[
      List[zio.aws.ec2.model.LaunchTemplateBlockDeviceMappingRequest.ReadOnly]
    ]
    def networkInterfaces: Option[List[
      zio.aws.ec2.model.LaunchTemplateInstanceNetworkInterfaceSpecificationRequest.ReadOnly
    ]]
    def imageId: Option[ImageId]
    def instanceType: Option[zio.aws.ec2.model.InstanceType]
    def keyName: Option[KeyPairName]
    def monitoring
        : Option[zio.aws.ec2.model.LaunchTemplatesMonitoringRequest.ReadOnly]
    def placement
        : Option[zio.aws.ec2.model.LaunchTemplatePlacementRequest.ReadOnly]
    def ramDiskId: Option[RamdiskId]
    def disableApiTermination: Option[Boolean]
    def instanceInitiatedShutdownBehavior
        : Option[zio.aws.ec2.model.ShutdownBehavior]
    def userData: Option[String]
    def tagSpecifications: Option[
      List[zio.aws.ec2.model.LaunchTemplateTagSpecificationRequest.ReadOnly]
    ]
    def elasticGpuSpecifications
        : Option[List[zio.aws.ec2.model.ElasticGpuSpecification.ReadOnly]]
    def elasticInferenceAccelerators: Option[
      List[zio.aws.ec2.model.LaunchTemplateElasticInferenceAccelerator.ReadOnly]
    ]
    def securityGroupIds: Option[List[SecurityGroupId]]
    def securityGroups: Option[List[SecurityGroupName]]
    def instanceMarketOptions: Option[
      zio.aws.ec2.model.LaunchTemplateInstanceMarketOptionsRequest.ReadOnly
    ]
    def creditSpecification
        : Option[zio.aws.ec2.model.CreditSpecificationRequest.ReadOnly]
    def cpuOptions
        : Option[zio.aws.ec2.model.LaunchTemplateCpuOptionsRequest.ReadOnly]
    def capacityReservationSpecification: Option[
      zio.aws.ec2.model.LaunchTemplateCapacityReservationSpecificationRequest.ReadOnly
    ]
    def licenseSpecifications: Option[
      List[zio.aws.ec2.model.LaunchTemplateLicenseConfigurationRequest.ReadOnly]
    ]
    def hibernationOptions: Option[
      zio.aws.ec2.model.LaunchTemplateHibernationOptionsRequest.ReadOnly
    ]
    def metadataOptions: Option[
      zio.aws.ec2.model.LaunchTemplateInstanceMetadataOptionsRequest.ReadOnly
    ]
    def enclaveOptions
        : Option[zio.aws.ec2.model.LaunchTemplateEnclaveOptionsRequest.ReadOnly]
    def instanceRequirements
        : Option[zio.aws.ec2.model.InstanceRequirementsRequest.ReadOnly]
    def privateDnsNameOptions: Option[
      zio.aws.ec2.model.LaunchTemplatePrivateDnsNameOptionsRequest.ReadOnly
    ]
    def maintenanceOptions: Option[
      zio.aws.ec2.model.LaunchTemplateInstanceMaintenanceOptionsRequest.ReadOnly
    ]
    def getKernelId: ZIO[Any, AwsError, KernelId] =
      AwsError.unwrapOptionField("kernelId", kernelId)
    def getEbsOptimized: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("ebsOptimized", ebsOptimized)
    def getIamInstanceProfile: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.LaunchTemplateIamInstanceProfileSpecificationRequest.ReadOnly
    ] = AwsError.unwrapOptionField("iamInstanceProfile", iamInstanceProfile)
    def getBlockDeviceMappings: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.LaunchTemplateBlockDeviceMappingRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("blockDeviceMappings", blockDeviceMappings)
    def getNetworkInterfaces: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.LaunchTemplateInstanceNetworkInterfaceSpecificationRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("networkInterfaces", networkInterfaces)
    def getImageId: ZIO[Any, AwsError, ImageId] =
      AwsError.unwrapOptionField("imageId", imageId)
    def getInstanceType: ZIO[Any, AwsError, zio.aws.ec2.model.InstanceType] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getKeyName: ZIO[Any, AwsError, KeyPairName] =
      AwsError.unwrapOptionField("keyName", keyName)
    def getMonitoring: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.LaunchTemplatesMonitoringRequest.ReadOnly
    ] = AwsError.unwrapOptionField("monitoring", monitoring)
    def getPlacement: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.LaunchTemplatePlacementRequest.ReadOnly
    ] = AwsError.unwrapOptionField("placement", placement)
    def getRamDiskId: ZIO[Any, AwsError, RamdiskId] =
      AwsError.unwrapOptionField("ramDiskId", ramDiskId)
    def getDisableApiTermination: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("disableApiTermination", disableApiTermination)
    def getInstanceInitiatedShutdownBehavior
        : ZIO[Any, AwsError, zio.aws.ec2.model.ShutdownBehavior] =
      AwsError.unwrapOptionField(
        "instanceInitiatedShutdownBehavior",
        instanceInitiatedShutdownBehavior
      )
    def getUserData: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("userData", userData)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.LaunchTemplateTagSpecificationRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
    def getElasticGpuSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.ElasticGpuSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "elasticGpuSpecifications",
      elasticGpuSpecifications
    )
    def getElasticInferenceAccelerators: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.LaunchTemplateElasticInferenceAccelerator.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "elasticInferenceAccelerators",
      elasticInferenceAccelerators
    )
    def getSecurityGroupIds: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getSecurityGroups: ZIO[Any, AwsError, List[SecurityGroupName]] =
      AwsError.unwrapOptionField("securityGroups", securityGroups)
    def getInstanceMarketOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.LaunchTemplateInstanceMarketOptionsRequest.ReadOnly
    ] =
      AwsError.unwrapOptionField("instanceMarketOptions", instanceMarketOptions)
    def getCreditSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.CreditSpecificationRequest.ReadOnly
    ] = AwsError.unwrapOptionField("creditSpecification", creditSpecification)
    def getCpuOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.LaunchTemplateCpuOptionsRequest.ReadOnly
    ] = AwsError.unwrapOptionField("cpuOptions", cpuOptions)
    def getCapacityReservationSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.LaunchTemplateCapacityReservationSpecificationRequest.ReadOnly
    ] = AwsError.unwrapOptionField(
      "capacityReservationSpecification",
      capacityReservationSpecification
    )
    def getLicenseSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.LaunchTemplateLicenseConfigurationRequest.ReadOnly
    ]] =
      AwsError.unwrapOptionField("licenseSpecifications", licenseSpecifications)
    def getHibernationOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.LaunchTemplateHibernationOptionsRequest.ReadOnly
    ] = AwsError.unwrapOptionField("hibernationOptions", hibernationOptions)
    def getMetadataOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.LaunchTemplateInstanceMetadataOptionsRequest.ReadOnly
    ] = AwsError.unwrapOptionField("metadataOptions", metadataOptions)
    def getEnclaveOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.LaunchTemplateEnclaveOptionsRequest.ReadOnly
    ] = AwsError.unwrapOptionField("enclaveOptions", enclaveOptions)
    def getInstanceRequirements: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.InstanceRequirementsRequest.ReadOnly
    ] = AwsError.unwrapOptionField("instanceRequirements", instanceRequirements)
    def getPrivateDnsNameOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.LaunchTemplatePrivateDnsNameOptionsRequest.ReadOnly
    ] =
      AwsError.unwrapOptionField("privateDnsNameOptions", privateDnsNameOptions)
    def getMaintenanceOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.LaunchTemplateInstanceMaintenanceOptionsRequest.ReadOnly
    ] = AwsError.unwrapOptionField("maintenanceOptions", maintenanceOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RequestLaunchTemplateData
  ) extends zio.aws.ec2.model.RequestLaunchTemplateData.ReadOnly {
    override val kernelId: Option[KernelId] = scala
      .Option(impl.kernelId())
      .map(value => zio.aws.ec2.model.primitives.KernelId(value))
    override val ebsOptimized: Option[Boolean] =
      scala.Option(impl.ebsOptimized()).map(value => value: Boolean)
    override val iamInstanceProfile: Option[
      zio.aws.ec2.model.LaunchTemplateIamInstanceProfileSpecificationRequest.ReadOnly
    ] = scala
      .Option(impl.iamInstanceProfile())
      .map(value =>
        zio.aws.ec2.model.LaunchTemplateIamInstanceProfileSpecificationRequest
          .wrap(value)
      )
    override val blockDeviceMappings: Option[
      List[zio.aws.ec2.model.LaunchTemplateBlockDeviceMappingRequest.ReadOnly]
    ] = scala
      .Option(impl.blockDeviceMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.LaunchTemplateBlockDeviceMappingRequest.wrap(item)
        }.toList
      )
    override val networkInterfaces: Option[List[
      zio.aws.ec2.model.LaunchTemplateInstanceNetworkInterfaceSpecificationRequest.ReadOnly
    ]] = scala
      .Option(impl.networkInterfaces())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.LaunchTemplateInstanceNetworkInterfaceSpecificationRequest
            .wrap(item)
        }.toList
      )
    override val imageId: Option[ImageId] = scala
      .Option(impl.imageId())
      .map(value => zio.aws.ec2.model.primitives.ImageId(value))
    override val instanceType: Option[zio.aws.ec2.model.InstanceType] = scala
      .Option(impl.instanceType())
      .map(value => zio.aws.ec2.model.InstanceType.wrap(value))
    override val keyName: Option[KeyPairName] = scala
      .Option(impl.keyName())
      .map(value => zio.aws.ec2.model.primitives.KeyPairName(value))
    override val monitoring
        : Option[zio.aws.ec2.model.LaunchTemplatesMonitoringRequest.ReadOnly] =
      scala
        .Option(impl.monitoring())
        .map(value =>
          zio.aws.ec2.model.LaunchTemplatesMonitoringRequest.wrap(value)
        )
    override val placement
        : Option[zio.aws.ec2.model.LaunchTemplatePlacementRequest.ReadOnly] =
      scala
        .Option(impl.placement())
        .map(value =>
          zio.aws.ec2.model.LaunchTemplatePlacementRequest.wrap(value)
        )
    override val ramDiskId: Option[RamdiskId] = scala
      .Option(impl.ramDiskId())
      .map(value => zio.aws.ec2.model.primitives.RamdiskId(value))
    override val disableApiTermination: Option[Boolean] =
      scala.Option(impl.disableApiTermination()).map(value => value: Boolean)
    override val instanceInitiatedShutdownBehavior
        : Option[zio.aws.ec2.model.ShutdownBehavior] = scala
      .Option(impl.instanceInitiatedShutdownBehavior())
      .map(value => zio.aws.ec2.model.ShutdownBehavior.wrap(value))
    override val userData: Option[String] =
      scala.Option(impl.userData()).map(value => value: String)
    override val tagSpecifications: Option[
      List[zio.aws.ec2.model.LaunchTemplateTagSpecificationRequest.ReadOnly]
    ] = scala
      .Option(impl.tagSpecifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.LaunchTemplateTagSpecificationRequest.wrap(item)
        }.toList
      )
    override val elasticGpuSpecifications
        : Option[List[zio.aws.ec2.model.ElasticGpuSpecification.ReadOnly]] =
      scala
        .Option(impl.elasticGpuSpecifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.ElasticGpuSpecification.wrap(item)
          }.toList
        )
    override val elasticInferenceAccelerators: Option[
      List[zio.aws.ec2.model.LaunchTemplateElasticInferenceAccelerator.ReadOnly]
    ] = scala
      .Option(impl.elasticInferenceAccelerators())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.LaunchTemplateElasticInferenceAccelerator.wrap(item)
        }.toList
      )
    override val securityGroupIds: Option[List[SecurityGroupId]] = scala
      .Option(impl.securityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.SecurityGroupId(item)
        }.toList
      )
    override val securityGroups: Option[List[SecurityGroupName]] = scala
      .Option(impl.securityGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.SecurityGroupName(item)
        }.toList
      )
    override val instanceMarketOptions: Option[
      zio.aws.ec2.model.LaunchTemplateInstanceMarketOptionsRequest.ReadOnly
    ] = scala
      .Option(impl.instanceMarketOptions())
      .map(value =>
        zio.aws.ec2.model.LaunchTemplateInstanceMarketOptionsRequest.wrap(value)
      )
    override val creditSpecification
        : Option[zio.aws.ec2.model.CreditSpecificationRequest.ReadOnly] = scala
      .Option(impl.creditSpecification())
      .map(value => zio.aws.ec2.model.CreditSpecificationRequest.wrap(value))
    override val cpuOptions
        : Option[zio.aws.ec2.model.LaunchTemplateCpuOptionsRequest.ReadOnly] =
      scala
        .Option(impl.cpuOptions())
        .map(value =>
          zio.aws.ec2.model.LaunchTemplateCpuOptionsRequest.wrap(value)
        )
    override val capacityReservationSpecification: Option[
      zio.aws.ec2.model.LaunchTemplateCapacityReservationSpecificationRequest.ReadOnly
    ] = scala
      .Option(impl.capacityReservationSpecification())
      .map(value =>
        zio.aws.ec2.model.LaunchTemplateCapacityReservationSpecificationRequest
          .wrap(value)
      )
    override val licenseSpecifications: Option[
      List[zio.aws.ec2.model.LaunchTemplateLicenseConfigurationRequest.ReadOnly]
    ] = scala
      .Option(impl.licenseSpecifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.LaunchTemplateLicenseConfigurationRequest.wrap(item)
        }.toList
      )
    override val hibernationOptions: Option[
      zio.aws.ec2.model.LaunchTemplateHibernationOptionsRequest.ReadOnly
    ] = scala
      .Option(impl.hibernationOptions())
      .map(value =>
        zio.aws.ec2.model.LaunchTemplateHibernationOptionsRequest.wrap(value)
      )
    override val metadataOptions: Option[
      zio.aws.ec2.model.LaunchTemplateInstanceMetadataOptionsRequest.ReadOnly
    ] = scala
      .Option(impl.metadataOptions())
      .map(value =>
        zio.aws.ec2.model.LaunchTemplateInstanceMetadataOptionsRequest
          .wrap(value)
      )
    override val enclaveOptions: Option[
      zio.aws.ec2.model.LaunchTemplateEnclaveOptionsRequest.ReadOnly
    ] = scala
      .Option(impl.enclaveOptions())
      .map(value =>
        zio.aws.ec2.model.LaunchTemplateEnclaveOptionsRequest.wrap(value)
      )
    override val instanceRequirements
        : Option[zio.aws.ec2.model.InstanceRequirementsRequest.ReadOnly] = scala
      .Option(impl.instanceRequirements())
      .map(value => zio.aws.ec2.model.InstanceRequirementsRequest.wrap(value))
    override val privateDnsNameOptions: Option[
      zio.aws.ec2.model.LaunchTemplatePrivateDnsNameOptionsRequest.ReadOnly
    ] = scala
      .Option(impl.privateDnsNameOptions())
      .map(value =>
        zio.aws.ec2.model.LaunchTemplatePrivateDnsNameOptionsRequest.wrap(value)
      )
    override val maintenanceOptions: Option[
      zio.aws.ec2.model.LaunchTemplateInstanceMaintenanceOptionsRequest.ReadOnly
    ] = scala
      .Option(impl.maintenanceOptions())
      .map(value =>
        zio.aws.ec2.model.LaunchTemplateInstanceMaintenanceOptionsRequest
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RequestLaunchTemplateData
  ): zio.aws.ec2.model.RequestLaunchTemplateData.ReadOnly = new Wrapper(impl)
}
