package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{NetworkAclId, NetworkAclAssociationId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ReplaceNetworkAclAssociationRequest(
    associationId: NetworkAclAssociationId,
    networkAclId: NetworkAclId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ReplaceNetworkAclAssociationRequest = {
    import ReplaceNetworkAclAssociationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ReplaceNetworkAclAssociationRequest
      .builder()
      .associationId(
        NetworkAclAssociationId.unwrap(associationId): java.lang.String
      )
      .networkAclId(NetworkAclId.unwrap(networkAclId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ReplaceNetworkAclAssociationRequest.ReadOnly =
    zio.aws.ec2.model.ReplaceNetworkAclAssociationRequest.wrap(buildAwsValue())
}
object ReplaceNetworkAclAssociationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ReplaceNetworkAclAssociationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ReplaceNetworkAclAssociationRequest =
      zio.aws.ec2.model
        .ReplaceNetworkAclAssociationRequest(associationId, networkAclId)
    def associationId: NetworkAclAssociationId
    def networkAclId: NetworkAclId
    def getAssociationId: ZIO[Any, Nothing, NetworkAclAssociationId] =
      ZIO.succeed(associationId)
    def getNetworkAclId: ZIO[Any, Nothing, NetworkAclId] =
      ZIO.succeed(networkAclId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ReplaceNetworkAclAssociationRequest
  ) extends zio.aws.ec2.model.ReplaceNetworkAclAssociationRequest.ReadOnly {
    override val associationId: NetworkAclAssociationId =
      zio.aws.ec2.model.primitives.NetworkAclAssociationId(impl.associationId())
    override val networkAclId: NetworkAclId =
      zio.aws.ec2.model.primitives.NetworkAclId(impl.networkAclId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ReplaceNetworkAclAssociationRequest
  ): zio.aws.ec2.model.ReplaceNetworkAclAssociationRequest.ReadOnly =
    new Wrapper(impl)
}
